/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class MethodCountInspection
extends BaseInspection {
    private static final int DEFAULT_METHOD_COUNT_LIMIT = 20;
    public int m_limit = 20;
    public boolean ignoreGettersAndSetters = false;

    @NotNull
    public String getID() {
        if ("ClassWithTooManyMethods" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classmetrics/MethodCountInspection.getID must not return null");
        }
        return "ClassWithTooManyMethods";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("too.many.methods.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classmetrics/MethodCountInspection.getDisplayName must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(InspectionGadgetsBundle.message("method.count.limit.option", new Object[0]));
        JFormattedTextField valueField = this.prepareNumberEditor("m_limit");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.left = 4;
        constraints.insets.right = 4;
        constraints.anchor = 17;
        panel.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets.left = 0;
        constraints.insets.right = 0;
        panel.add((Component)valueField, constraints);
        JCheckBox gettersSettersCheckBox = new JCheckBox(InspectionGadgetsBundle.message("method.count.ignore.getters.setters.option", new Object[0]), this.ignoreGettersAndSetters);
        final ButtonModel arrayModel = gettersSettersCheckBox.getModel();
        arrayModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MethodCountInspection.this.ignoreGettersAndSetters = arrayModel.isSelected();
            }
        });
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weighty = 1.0;
        constraints.gridwidth = 2;
        constraints.anchor = 18;
        panel.add((Component)gettersSettersCheckBox, constraints);
        return panel;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer count = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("too.many.methods.problem.descriptor", count);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classmetrics/MethodCountInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCountVisitor();
    }

    private class MethodCountVisitor
    extends BaseInspectionVisitor {
        private MethodCountVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classmetrics/MethodCountInspection$MethodCountVisitor.visitClass must not be null");
            }
            int methodCount = this.calculateTotalMethodCount(aClass);
            if (methodCount <= MethodCountInspection.this.m_limit) {
                return;
            }
            this.registerClassError(aClass, methodCount);
        }

        private int calculateTotalMethodCount(PsiClass aClass) {
            PsiMethod[] methods = aClass.getMethods();
            int totalCount = 0;
            for (PsiMethod method : methods) {
                if (method.isConstructor() || MethodCountInspection.this.ignoreGettersAndSetters && (MethodUtils.isSimpleGetter(method) || MethodUtils.isSimpleSetter(method))) continue;
                ++totalCount;
            }
            return totalCount;
        }
    }
}

