/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ReplaceAllDotInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("replace.all.dot.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ReplaceAllDotInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("replace.all.dot.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ReplaceAllDotInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SystemSetSecurityManagerVisitor();
    }

    private static class SystemSetSecurityManagerVisitor
    extends BaseInspectionVisitor {
        private SystemSetSecurityManagerVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/ReplaceAllDotInspection$SystemSetSecurityManagerVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"replaceAll".equals(methodName)) {
                return;
            }
            PsiExpressionList argList = expression.getArgumentList();
            PsiExpression[] args = argList.getExpressions();
            if (args.length != 2) {
                return;
            }
            PsiExpression arg = args[0];
            if (!PsiUtil.isConstantExpression((PsiExpression)arg)) {
                return;
            }
            PsiType argType = arg.getType();
            if (argType == null) {
                return;
            }
            if (!"java.lang.String".equals(argType.getCanonicalText())) {
                return;
            }
            String argValue = (String)ConstantExpressionUtil.computeCastTo((PsiExpression)arg, (PsiType)argType);
            if (!".".equals(argValue)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String qualifiedName = containingClass.getQualifiedName();
            if (!"java.lang.String".equals(qualifiedName)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }
}

