/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class PrimitiveArrayArgumentToVariableArgMethodInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("primitive.array.argument.to.var.arg.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/PrimitiveArrayArgumentToVariableArgMethodInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("primitive.array.argument.to.var.arg.method.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/PrimitiveArrayArgumentToVariableArgMethodInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PrimitiveArrayArgumentToVariableArgVisitor();
    }

    private static boolean isPrimitiveArrayType(PsiType type) {
        if (type == null) {
            return false;
        }
        if (!(type instanceof PsiArrayType)) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)type).getComponentType();
        return TypeConversionUtil.isPrimitiveAndNotNull((PsiType)componentType);
    }

    private static boolean isDeepPrimitiveArrayType(PsiType type) {
        if (!(type instanceof PsiArrayType)) {
            return false;
        }
        PsiType componentType = type.getDeepComponentType();
        return TypeConversionUtil.isPrimitiveAndNotNull((PsiType)componentType);
    }

    private static class PrimitiveArrayArgumentToVariableArgVisitor
    extends BaseInspectionVisitor {
        private PrimitiveArrayArgumentToVariableArgVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/PrimitiveArrayArgumentToVariableArgMethodInspection$PrimitiveArrayArgumentToVariableArgVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(call);
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)call)) {
                return;
            }
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression lastArgument = arguments[arguments.length - 1];
            PsiType argumentType = lastArgument.getType();
            if (!PrimitiveArrayArgumentToVariableArgMethodInspection.isPrimitiveArrayType(argumentType)) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != arguments.length) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter lastParameter = parameters[parameters.length - 1];
            if (!lastParameter.isVarArgs()) {
                return;
            }
            PsiType parameterType = lastParameter.getType();
            if (PrimitiveArrayArgumentToVariableArgMethodInspection.isDeepPrimitiveArrayType(parameterType)) {
                return;
            }
            this.registerError((PsiElement)lastArgument, new Object[0]);
        }
    }
}

