/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplicitArrayToStringInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("implicit.array.to.string.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ImplicitArrayToStringInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string;
        if (infos[0] instanceof PsiMethodCallExpression) {
            string = InspectionGadgetsBundle.message("implicit.array.to.string.method.call.problem.descriptor", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ImplicitArrayToStringInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("implicit.array.to.string.problem.descriptor", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ImplicitArrayToStringInspection.buildErrorString must not return null");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiType componentType;
        PsiExpression expression = (PsiExpression)infos[0];
        PsiArrayType type = (PsiArrayType)expression.getType();
        if (type != null && (componentType = type.getComponentType()) instanceof PsiArrayType) {
            return new ImplicitArrayToStringFix(true);
        }
        return new ImplicitArrayToStringFix(false);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ImplicitArrayToStringVisitor();
    }

    private static class ImplicitArrayToStringVisitor
    extends BaseInspectionVisitor {
        private ImplicitArrayToStringVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            super.visitReferenceExpression(expression);
            if (!ImplicitArrayToStringVisitor.isImplicitArrayToStringCall((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            if (!ImplicitArrayToStringVisitor.isImplicitArrayToStringCall((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            if (!ImplicitArrayToStringVisitor.isImplicitArrayToStringCall((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private static boolean isImplicitArrayToStringCall(PsiExpression expression) {
            PsiType type = expression.getType();
            if (!(type instanceof PsiArrayType)) {
                return false;
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
                IElementType tokenType = binaryExpression.getOperationTokenType();
                if (!JavaTokenType.PLUS.equals(tokenType)) {
                    return false;
                }
                PsiExpression lhs = binaryExpression.getLOperand();
                if (lhs != expression) {
                    PsiType lhsType = lhs.getType();
                    return lhsType != null && lhsType.equalsToText("java.lang.String");
                }
                PsiExpression rhs = binaryExpression.getROperand();
                if (rhs != null && rhs != expression) {
                    PsiType rhsType = rhs.getType();
                    return rhsType != null && rhsType.equalsToText("java.lang.String");
                }
            } else if (parent instanceof PsiExpressionList) {
                PsiArrayType arrayType;
                PsiType componentType;
                PsiExpression qualifier;
                PsiExpressionList expressionList = (PsiExpressionList)parent;
                PsiElement grandParent = expressionList.getParent();
                if (!(grandParent instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                String methodName = methodExpression.getReferenceName();
                if (!"print".equals(methodName) && !"println".equals(methodName)) {
                    if (!"printf".equals(methodName) && !"format".equals(methodName)) {
                        return false;
                    }
                    PsiExpression[] expressions = expressionList.getExpressions();
                    if (expressions.length < 1) {
                        return false;
                    }
                    PsiType firstExpressionType = expressions[0].getType();
                    if (firstExpressionType == null) {
                        return false;
                    }
                    if (firstExpressionType.equalsToText("java.util.Locale") ? expressions.length < 4 : expressions.length < 3) {
                        return false;
                    }
                }
                if (TypeUtils.expressionHasTypeOrSubtype(qualifier = methodExpression.getQualifierExpression(), "java.io.PrintStream", "java.util.Formatter", "java.io.PrintWriter") == null) {
                    if (!(qualifier instanceof PsiReferenceExpression)) {
                        return false;
                    }
                    PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                    PsiElement target = referenceExpression.resolve();
                    if (!(target instanceof PsiClass)) {
                        return false;
                    }
                    PsiClass aClass = (PsiClass)target;
                    String className = aClass.getQualifiedName();
                    if (!"java.lang.String".equals(className)) {
                        return false;
                    }
                }
                return (componentType = (arrayType = (PsiArrayType)type).getComponentType()) != PsiType.CHAR;
            }
            return false;
        }
    }

    private static class ImplicitArrayToStringFix
    extends InspectionGadgetsFix {
        private final boolean deepString;

        ImplicitArrayToStringFix(boolean deepString) {
            this.deepString = deepString;
        }

        @NotNull
        public String getName() {
            String expressionText = this.deepString ? "java.util.Arrays.deepToString()" : "java.util.Arrays.toString()";
            String string = InspectionGadgetsBundle.message("implicit.array.to.string.quickfix", expressionText);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/ImplicitArrayToStringInspection$ImplicitArrayToStringFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiExpression expression = (PsiExpression)descriptor.getPsiElement();
            String expressionText = expression.getText();
            String newExpressionText = this.deepString ? "java.util.Arrays.deepToString(" + expressionText + ')' : "java.util.Arrays.toString(" + expressionText + ')';
            ImplicitArrayToStringFix.replaceExpressionAndShorten(expression, newExpressionText);
        }
    }
}

