/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class EmptyStatementBodyInspection
extends BaseInspection {
    public boolean m_reportEmptyBlocks = false;

    @NotNull
    public String getID() {
        if ("StatementWithEmptyBody" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/EmptyStatementBodyInspection.getID must not return null");
        }
        return "StatementWithEmptyBody";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("statement.with.empty.body.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/EmptyStatementBodyInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("statement.with.empty.body.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/EmptyStatementBodyInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("statement.with.empty.body.include.option", new Object[0]), (InspectionProfileEntry)this, "m_reportEmptyBlocks");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyStatementVisitor();
    }

    private class EmptyStatementVisitor
    extends BaseInspectionVisitor {
        private EmptyStatementVisitor() {
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/EmptyStatementBodyInspection$EmptyStatementVisitor.visitDoWhileStatement must not be null");
            }
            super.visitDoWhileStatement(statement);
            if (JspPsiUtil.isInJspFile((PsiElement)statement.getContainingFile())) {
                return;
            }
            PsiStatement body = statement.getBody();
            if (body == null || !this.isEmpty((PsiElement)body)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/EmptyStatementBodyInspection$EmptyStatementVisitor.visitWhileStatement must not be null");
            }
            super.visitWhileStatement(statement);
            if (JspPsiUtil.isInJspFile((PsiElement)statement.getContainingFile())) {
                return;
            }
            PsiStatement body = statement.getBody();
            if (body == null || !this.isEmpty((PsiElement)body)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/EmptyStatementBodyInspection$EmptyStatementVisitor.visitForStatement must not be null");
            }
            super.visitForStatement(statement);
            if (JspPsiUtil.isInJspFile((PsiElement)statement.getContainingFile())) {
                return;
            }
            PsiStatement body = statement.getBody();
            if (body == null || !this.isEmpty((PsiElement)body)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/EmptyStatementBodyInspection$EmptyStatementVisitor.visitForeachStatement must not be null");
            }
            super.visitForeachStatement(statement);
            if (JspPsiUtil.isInJspFile((PsiElement)statement.getContainingFile())) {
                return;
            }
            PsiStatement body = statement.getBody();
            if (body == null || !this.isEmpty((PsiElement)body)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/EmptyStatementBodyInspection$EmptyStatementVisitor.visitIfStatement must not be null");
            }
            super.visitIfStatement(statement);
            if (JspPsiUtil.isInJspFile((PsiElement)statement.getContainingFile())) {
                return;
            }
            PsiStatement thenBranch = statement.getThenBranch();
            if (thenBranch != null && this.isEmpty((PsiElement)thenBranch)) {
                this.registerStatementError((PsiStatement)statement, new Object[0]);
                return;
            }
            PsiStatement elseBranch = statement.getElseBranch();
            if (elseBranch != null && this.isEmpty((PsiElement)elseBranch)) {
                PsiKeyword elseToken = statement.getElseElement();
                if (elseToken == null) {
                    return;
                }
                this.registerError((PsiElement)elseToken, new Object[0]);
            }
        }

        private boolean isEmpty(PsiElement body) {
            if (body instanceof PsiEmptyStatement) {
                return true;
            }
            if (EmptyStatementBodyInspection.this.m_reportEmptyBlocks && body instanceof PsiBlockStatement) {
                PsiBlockStatement block = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = block.getCodeBlock();
                return this.codeBlockIsEmpty(codeBlock);
            }
            if (body instanceof PsiCodeBlock) {
                PsiCodeBlock codeBlock = (PsiCodeBlock)body;
                return this.codeBlockIsEmpty(codeBlock);
            }
            return false;
        }

        private boolean codeBlockIsEmpty(PsiCodeBlock codeBlock) {
            PsiStatement[] statements = codeBlock.getStatements();
            return statements.length == 0;
        }
    }
}

