/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.WellFormednessUtils;
import org.jetbrains.annotations.NotNull;

public class AssignmentUsedAsConditionInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assignment.used.as.condition.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/assignment/AssignmentUsedAsConditionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assignment.used.as.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/assignment/AssignmentUsedAsConditionInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new AssignmentUsedAsConditionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentUsedAsConditionVisitor();
    }

    private static class AssignmentUsedAsConditionVisitor
    extends BaseInspectionVisitor {
        private AssignmentUsedAsConditionVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/assignment/AssignmentUsedAsConditionInspection$AssignmentUsedAsConditionVisitor.visitAssignmentExpression must not be null");
            }
            super.visitAssignmentExpression(expression);
            if (!WellFormednessUtils.isWellFormed(expression)) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (parent == null) {
                return;
            }
            if (parent instanceof PsiIfStatement) {
                this.checkIfStatementCondition((PsiIfStatement)parent, expression);
            }
            if (parent instanceof PsiWhileStatement) {
                this.checkWhileStatementCondition((PsiWhileStatement)parent, expression);
            }
            if (parent instanceof PsiForStatement) {
                this.checkForStatementCondition((PsiForStatement)parent, expression);
            }
            if (parent instanceof PsiDoWhileStatement) {
                this.checkDoWhileStatementCondition((PsiDoWhileStatement)parent, expression);
            }
        }

        private void checkIfStatementCondition(PsiIfStatement ifStatement, PsiAssignmentExpression expression) {
            PsiExpression condition = ifStatement.getCondition();
            if (expression.equals(condition)) {
                this.registerError((PsiElement)expression, new Object[0]);
            }
        }

        private void checkDoWhileStatementCondition(PsiDoWhileStatement doWhileStatement, PsiAssignmentExpression expression) {
            PsiExpression condition = doWhileStatement.getCondition();
            if (expression.equals(condition)) {
                this.registerError((PsiElement)expression, new Object[0]);
            }
        }

        private void checkForStatementCondition(PsiForStatement forStatement, PsiAssignmentExpression expression) {
            PsiExpression condition = forStatement.getCondition();
            if (expression.equals(condition)) {
                this.registerError((PsiElement)expression, new Object[0]);
            }
        }

        private void checkWhileStatementCondition(PsiWhileStatement whileStatement, PsiAssignmentExpression expression) {
            PsiExpression condition = whileStatement.getCondition();
            if (expression.equals(condition)) {
                this.registerError((PsiElement)expression, new Object[0]);
            }
        }
    }

    private static class AssignmentUsedAsConditionFix
    extends InspectionGadgetsFix {
        private AssignmentUsedAsConditionFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("assignment.used.as.condition.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/assignment/AssignmentUsedAsConditionInspection$AssignmentUsedAsConditionFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiAssignmentExpression expression = (PsiAssignmentExpression)descriptor.getPsiElement();
            PsiExpression leftExpression = expression.getLExpression();
            PsiExpression rightExpression = expression.getRExpression();
            assert (rightExpression != null);
            String newExpression = leftExpression.getText() + "==" + rightExpression.getText();
            AssignmentUsedAsConditionFix.replaceExpression((PsiExpression)expression, newExpression);
        }
    }
}

