/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.StringBuilderSpinAllocator;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil
extends com.intellij.openapi.util.text.StringUtil {
    private static final Logger LOG = Logger.getInstance((String)StringUtil.class.getName());
    public static final char[] DEFAULT_SEPARATORS = new char[]{' ', ',', '\n', '\r', '\t', ';'};
    public static final String EMPTY = "";
    @NonNls
    public static final String NA = "N/A";
    private static final String STD_EX_SUFFIX = "Valid property list format is (name( )*=( )*'escaped_value'( )*)* where escape simbol is \"|\"";
    private static final String NON_ALPHA_NUM = "[^A-Za-z0-9_]";

    private StringUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String escapeHTML(String text, boolean replaceQuotes) {
        if (text == null) {
            return EMPTY;
        }
        StringBuilder result = StringBuilderSpinAllocator.alloc();
        try {
            StringCharacterIterator iterator = new StringCharacterIterator(text);
            char character = iterator.current();
            while (character != '\uffff') {
                if (character == '<') {
                    result.append("&lt;");
                } else if (character == '>') {
                    result.append("&gt;");
                } else if (character == '\"' && replaceQuotes) {
                    result.append("&quot;");
                } else if (character == '\'' && replaceQuotes) {
                    result.append("&#039;");
                } else if (character == '\\') {
                    result.append("&#092;");
                } else if (character == '&') {
                    result.append("&amp;");
                } else {
                    result.append(character);
                }
                character = iterator.next();
            }
            String string = result.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)result);
        }
    }

    public static String biteOffPostfix(String line, String postfix) {
        return line.substring(0, line.length() - postfix.length());
    }

    public static String lastPartOf(String s, char separator) {
        int i = s.lastIndexOf(separator);
        if (i >= 0) {
            return s.substring(i + 1);
        }
        return s;
    }

    public static String truncateStringValue(String str, int maxLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > maxLength) {
            return str.substring(0, maxLength - 1);
        }
        return str;
    }

    @Nullable
    public static String truncateStringValueWithDots(String str, int maxLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > maxLength) {
            return str.substring(0, maxLength - 1 - 3) + "...";
        }
        return str;
    }

    public static boolean isValidXMLChar(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': {
                return true;
            }
        }
        return ' ' <= c && c <= '\ud7ff' || '\ue000' <= c && c <= '\ufffd' || '\u10000' <= c && c <= '\u10ffff';
    }

    public static int findInvalidXMLChar(String value) {
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (StringUtil.isValidXMLChar(chars[i])) continue;
            return i;
        }
        return -1;
    }

    public static String generateUniqueHash() {
        StringBuilder sb = new StringBuilder();
        Random random = StringUtil.createRandom();
        for (int i = 0; i < 32; ++i) {
            int rand;
            sb.append((char)(rand += (rand = (int)(random.nextDouble() * 62.0)) < 10 ? 48 : (rand < 36 ? 55 : 61)));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Random createRandom() {
        Random random = new Random();
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        finally {
            random.setSeed(System.nanoTime());
        }
        return random;
    }

    @NotNull
    public static String stripNewLine(@NotNull String s) {
        char firstChar;
        char lastChar;
        int endCharsOff;
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/StringUtil.stripNewLine must not be null");
        }
        for (endCharsOff = 0; s.length() > endCharsOff && ((lastChar = s.charAt(s.length() - endCharsOff - 1)) == '\n' || lastChar == '\r'); ++endCharsOff) {
        }
        int beginCharsOff = 0;
        while (s.length() > beginCharsOff + endCharsOff && ((firstChar = s.charAt(beginCharsOff)) == '\n' || firstChar == '\r')) {
            ++beginCharsOff;
        }
        String string = endCharsOff > 0 || beginCharsOff > 0 ? s.substring(beginCharsOff, s.length() - endCharsOff) : s;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/StringUtil.stripNewLine must not return null");
        }
        return string;
    }

    public static Pattern searchByKeywordPattern(@NotNull String keyword, boolean caseInsensitive) {
        if (keyword == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/StringUtil.searchByKeywordPattern must not be null");
        }
        String escapedKeyword = StringUtil.escapeForRegex(keyword);
        int flags = 0;
        if (caseInsensitive) {
            flags = 66;
        }
        return Pattern.compile(".*\\b" + escapedKeyword + ".*", flags);
    }

    private static String escapeForRegex(@NotNull String keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/util/StringUtil.escapeForRegex must not be null");
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < keyword.length(); ++i) {
            char c = keyword.charAt(i);
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    builder.append("\\");
                }
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static List<String> split(String values) {
        return StringUtil.split(values, DEFAULT_SEPARATORS);
    }

    public static List<String> split(String values, char ... separators) {
        ArrayList<String> result = new ArrayList<String>();
        char[] currentWord = new char[values.length()];
        int currentEndPosition = 0;
        for (int i = 0; i < values.length(); ++i) {
            char currentChar = values.charAt(i);
            if (StringUtil.isSeparator(currentChar, separators)) {
                if (currentEndPosition <= 0) continue;
                result.add(new String(currentWord, 0, currentEndPosition));
                currentEndPosition = 0;
                continue;
            }
            currentWord[currentEndPosition] = currentChar;
            ++currentEndPosition;
        }
        if (currentEndPosition > 0) {
            result.add(new String(currentWord, 0, currentEndPosition));
        }
        return result;
    }

    private static boolean isSeparator(char currentChar, char[] separators) {
        for (char separator : separators) {
            if (currentChar != separator) continue;
            return true;
        }
        return false;
    }

    public static boolean isAPositiveNumber(String value) {
        try {
            int intValue = Integer.parseInt(value);
            return intValue > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isNumber(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String formatHtmlColor(Color color) {
        String rgb = Integer.toHexString(color.getRGB());
        rgb = rgb.substring(2, rgb.length());
        return '#' + rgb;
    }

    public static String getOrdinal(int number) {
        String txt;
        int remains = number - 10 * (number / 10);
        switch (remains) {
            case 1: {
                txt = "st";
                break;
            }
            case 2: {
                txt = "nd";
                break;
            }
            case 3: {
                txt = "rd";
                break;
            }
            default: {
                txt = "th";
            }
        }
        return txt;
    }

    public static String stackTrace(Throwable exception) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(buffer);
        exception.printStackTrace(printStream);
        printStream.close();
        return buffer.toString();
    }

    public static Iterator<String> createEscapedTokenizer(String string, char del) {
        return new MyTokenizerIterator(string, del);
    }

    public static int indexOf(String currentString, char findWhat, EscapeInfoProvider escaper) {
        for (int i = 0; i < currentString.length(); ++i) {
            char currentChar = currentString.charAt(i);
            if (escaper.escapeCharacter() == currentChar) {
                ++i;
                continue;
            }
            if (currentChar != findWhat) continue;
            return i;
        }
        return -1;
    }

    public static Map<String, String> stringToProperties(String string, EscapeInfoProvider escaper) throws ParseException {
        String currentString = string;
        HashMap<String, String> result = new HashMap<String, String>();
        while (currentString.length() > 0) {
            int nameSep = currentString.indexOf("=");
            if (nameSep == -1) {
                throw new ParseException("Property value not found\nValid property list format is (name( )*=( )*'escaped_value'( )*)* where escape simbol is \"|\"", 0);
            }
            String name = currentString.substring(0, nameSep).trim();
            if (!StringUtil.isValidJavaIdentifier(name)) {
                throw new ParseException("Incorrect property name.\nValid property list format is (name( )*=( )*'escaped_value'( )*)* where escape simbol is \"|\"", 0);
            }
            if ((currentString = currentString.substring(nameSep + 1).trim()).startsWith("'")) {
                int endOfValue = StringUtil.indexOf(currentString = currentString.substring(1), '\'', escaper);
                if (endOfValue >= 0) {
                    String escapedValue = currentString.substring(0, endOfValue);
                    currentString = currentString.substring(endOfValue + 1).trim();
                    result.put(name, StringUtil.unescapeStr(escapedValue, escaper));
                    continue;
                }
                throw new ParseException("Value should end with \"'\"\nValid property list format is (name( )*=( )*'escaped_value'( )*)* where escape simbol is \"|\"", 0);
            }
            throw new ParseException("Value should start with \"'\"\nValid property list format is (name( )*=( )*'escaped_value'( )*)* where escape simbol is \"|\"", 0);
        }
        return result;
    }

    private static boolean isValidJavaIdentifier(String name) {
        if (name.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String repeat(String whatRepeat, String separator, int length) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(whatRepeat);
        }
        return result.toString();
    }

    public static boolean isTrue(String property) {
        return Boolean.parseBoolean(property) || "yes".equalsIgnoreCase(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processLines(String str, LineProcessor procesor) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(str));
        try {
            StringUtil.processLines(reader, procesor);
        }
        finally {
            reader.close();
        }
    }

    private static void processLines(BufferedReader reader, LineProcessor procesor) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (!procesor.processLine(line)) continue;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String formatFileSize(long size) {
        String string;
        String string2;
        try {
            string2 = com.intellij.openapi.util.text.StringUtil.formatFileSize((long)size);
        }
        catch (MissingResourceException e) {
            LOG.warn(e.toString());
            if (!(size == 1L ? (string = size + " byte") != null : (string = size + " bytes") != null)) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/StringUtil.formatFileSize must not return null");
            return string;
        }
        string = string2;
        if (string2 == null) throw new IllegalStateException("@NotNull method jetbrains/buildServer/util/StringUtil.formatFileSize must not return null");
        return string;
    }

    public static void processLines(InputStream in, LineProcessor procesor) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringUtil.processLines(reader, procesor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processLines(File file, LineProcessor procesor) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            StringUtil.processLines(in, procesor);
        }
        finally {
            in.close();
        }
    }

    public static String escapeStr(String str, EscapeInfoProvider p) {
        if (str == null) {
            return null;
        }
        int finalCount = StringUtil.calcFinalEscapedStringCount(str, p);
        if (str.length() == finalCount) {
            return str;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            char escaped = p.escape(c);
            if (escaped != '\u0000') {
                resultChars[resultPos++] = p.escapeCharacter();
                resultChars[resultPos++] = escaped;
                continue;
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect escaping for '" + str + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalEscapedStringCount(String name, EscapeInfoProvider p) {
        int result = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (p.escape(c) != '\u0000') {
                result += 2;
                continue;
            }
            ++result;
        }
        return result;
    }

    public static String unescapeStr(String str, EscapeInfoProvider p) {
        if (str == null) {
            return null;
        }
        int finalCount = StringUtil.calcFinalUnescapedStringCount(str, p);
        int len = str.length();
        if (len == finalCount) {
            return str;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i = 0; i < len; ++i) {
            char nextChar;
            char unescaped;
            char c = str.charAt(i);
            if (c == p.escapeCharacter() && i < len - 1 && (unescaped = p.unescape(nextChar = str.charAt(i + 1))) != '\u0000') {
                c = unescaped;
                ++i;
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect unescaping for '" + str + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalUnescapedStringCount(String name, EscapeInfoProvider p) {
        int result = 0;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char nextChar;
            char c = name.charAt(i);
            if (c == p.escapeCharacter() && i < len - 1 && p.unescape(nextChar = name.charAt(i + 1)) != '\u0000') {
                ++i;
            }
            ++result;
        }
        return result;
    }

    public static String formatTextForWeb(String txt) {
        if (txt == null) {
            return null;
        }
        return StringUtil.escapeHTML(txt, true).replace("\r\n", "\n").replace("\n", "<br />\n");
    }

    public static String replaceNonAlphaNumericChars(String originalStr, char toReplace) {
        return originalStr.replaceAll(NON_ALPHA_NUM, String.valueOf(toReplace));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyTokenizerIterator
    implements Iterator<String> {
        private int myNextPosition = 0;
        private String myString;
        private final char myDel;

        public MyTokenizerIterator(String string, char del) {
            this.myString = string;
            this.myDel = del;
        }

        @Override
        public boolean hasNext() {
            return this.myNextPosition < this.myString.length();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int lastIndex = this.myNextPosition;
            while (lastIndex < this.myString.length()) {
                char nextChar = this.myString.charAt(lastIndex);
                if (nextChar == '\\') {
                    if (nextChar == this.myString.length() - 1) {
                        try {
                            String string = this.myString.substring(this.myNextPosition);
                            return string;
                        }
                        finally {
                            this.myNextPosition = lastIndex + 1;
                        }
                    }
                    ++lastIndex;
                    ++lastIndex;
                    continue;
                }
                if (nextChar == this.myDel) {
                    try {
                        String string = this.myString.substring(this.myNextPosition, lastIndex);
                        return string;
                    }
                    finally {
                        this.myNextPosition = lastIndex + 1;
                    }
                }
                ++lastIndex;
            }
            try {
                String string = this.myString.substring(this.myNextPosition);
                return string;
            }
            finally {
                this.myNextPosition = lastIndex + 1;
            }
        }

        @Override
        public void remove() {
            throw new RuntimeException("Remove not supported");
        }
    }

    public static interface EscapeInfoProvider {
        public char escape(char var1);

        public char unescape(char var1);

        public char escapeCharacter();
    }

    public static interface LineProcessor {
        public boolean processLine(String var1);
    }
}

