/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSInputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSWriteLock;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class FSRecoverer {
    private FSFS myOwner;
    private ISVNCanceller myCanceller;

    public FSRecoverer(FSFS owner, ISVNCanceller canceller) {
        this.myOwner = owner;
        this.myCanceller = canceller == null ? ISVNCanceller.NULL : canceller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runRecovery() throws SVNException {
        FSWriteLock writeLock;
        FSWriteLock fSWriteLock = writeLock = FSWriteLock.getWriteLockForDB(this.myOwner);
        synchronized (fSWriteLock) {
            try {
                writeLock.lock();
                this.recover();
            }
            finally {
                writeLock.unlock();
                FSWriteLock.release(writeLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recover() throws SVNException {
        SVNErrorMessage err;
        String nextNodeID = null;
        String nextCopyID = null;
        long maxRev = this.getLargestRevision();
        long youngestRev = this.myOwner.getYoungestRevision();
        if (youngestRev > maxRev) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Expected current rev to be <= {0} but found {1}", new Object[]{String.valueOf(maxRev), String.valueOf(youngestRev)});
            SVNErrorManager.error(err2, SVNLogType.FSFS);
        }
        if (this.myOwner.getDBFormat() < 3) {
            long[] rootOffset = new long[]{-1L};
            String[] maxNodeID = new String[]{"0"};
            String[] maxCopyID = new String[]{"0"};
            for (long rev = 0L; rev <= maxRev; ++rev) {
                this.myCanceller.checkCancelled();
                FSFile revFile = null;
                try {
                    revFile = this.myOwner.getPackOrRevisionFSFile(rev);
                    FSRepositoryUtil.loadRootChangesOffset(this.myOwner, rev, revFile, rootOffset, null);
                    this.findMaxIDs(rev, revFile, rootOffset[0], maxNodeID, maxCopyID);
                    continue;
                }
                finally {
                    if (revFile != null) {
                        revFile.close();
                    }
                }
            }
            nextNodeID = FSRepositoryUtil.generateNextKey(maxNodeID[0]);
            nextCopyID = FSRepositoryUtil.generateNextKey(maxCopyID[0]);
        }
        File revpropFile = null;
        try {
            revpropFile = this.myOwner.getRevisionPropertiesFile(maxRev, false);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NO_SUCH_REVISION) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Revision {0} has a revs file but no revprops file", String.valueOf(maxRev));
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            throw svne;
        }
        if (!revpropFile.isFile()) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Revision {0} has a non-file where its revprops file should be", String.valueOf(maxRev));
            SVNErrorManager.error(err3, SVNLogType.FSFS);
        }
        try {
            this.myOwner.writeCurrentFile(maxRev, nextNodeID, nextCopyID);
        }
        catch (IOException ioe) {
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findMaxIDs(long rev, FSFile revFile, long offset, String[] maxNodeID, String[] maxCopyID) throws SVNException {
        String textRep;
        revFile.seek(offset);
        Map headers = null;
        try {
            headers = revFile.readHeader();
        }
        finally {
            revFile.close();
        }
        String revNodeIDStr = (String)headers.get("id");
        FSID revNodeID = FSID.fromString(revNodeIDStr);
        SVNNodeKind nodeKind = SVNNodeKind.parseKind((String)headers.get("type"));
        if (nodeKind != SVNNodeKind.DIR) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Recovery encountered a non-directory node");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if ((textRep = (String)headers.get("text")) == null) {
            return;
        }
        FSRevisionNode revNode = new FSRevisionNode();
        revNode.setId(revNodeID);
        revNode.setType(nodeKind);
        FSRevisionNode.parseRepresentationHeader(textRep, revNode, null, true, false);
        if (revNode.getTextRepresentation().getRevision() != rev) {
            return;
        }
        revFile.seek(revNode.getTextRepresentation().getOffset());
        FSInputStream.FSRepresentationState repState = FSInputStream.readRepresentationLine(revFile);
        if (repState.myIsDelta) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Recovery encountered a deltified directory representation");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        SVNProperties rawEntries = revFile.readProperties(false, false);
        Iterator entriesIter = rawEntries.nameSet().iterator();
        while (entriesIter.hasNext()) {
            String rawID;
            FSID id;
            String kindStr;
            SVNNodeKind kind;
            String name = (String)entriesIter.next();
            String unparsedEntry = rawEntries.getStringValue(name);
            int spaceInd = unparsedEntry.indexOf(32);
            if (spaceInd == -1 || spaceInd == unparsedEntry.length() - 1 || spaceInd == 0) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Directory entry corrupt");
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            if ((kind = SVNNodeKind.parseKind(kindStr = unparsedEntry.substring(0, spaceInd))) != SVNNodeKind.DIR && kind != SVNNodeKind.FILE) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Directory entry corrupt");
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            if ((id = FSID.fromString(rawID = unparsedEntry.substring(spaceInd + 1))).getRevision() != rev) continue;
            String nodeID = id.getNodeID();
            String copyID = id.getCopyID();
            if (nodeID.compareTo(maxNodeID[0]) > 0) {
                maxNodeID[0] = nodeID;
            }
            if (copyID.compareTo(maxCopyID[0]) > 0) {
                maxCopyID[0] = copyID;
            }
            if (kind == SVNNodeKind.FILE) continue;
            this.findMaxIDs(rev, revFile, id.getOffset(), maxNodeID, maxCopyID);
        }
    }

    private long getLargestRevision() throws SVNException {
        long right = 1L;
        while (true) {
            try {
                this.myOwner.getPackOrRevisionFSFile(right);
            }
            catch (SVNException svne) {
                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NO_SUCH_REVISION) break;
                throw svne;
            }
            right <<= 1;
        }
        long left = right >> 1;
        while (left + 1L < right) {
            long probe = left + (right - left) / 2L;
            try {
                this.myOwner.getPackOrRevisionFSFile(probe);
                left = probe;
            }
            catch (SVNException svne) {
                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NO_SUCH_REVISION) {
                    right = probe;
                    continue;
                }
                throw svne;
            }
        }
        return left;
    }
}

