/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.move;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassHandler;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.refactoring.GroovyChangeContextUtil;

public class MoveGroovyClassHandler
implements MoveClassHandler {
    public PsiClass doMoveClass(@NotNull PsiClass aClass, @NotNull PsiDirectory moveDestination) throws IncorrectOperationException {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/move/MoveGroovyClassHandler.doMoveClass must not be null");
        }
        if (moveDestination == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/move/MoveGroovyClassHandler.doMoveClass must not be null");
        }
        if (!aClass.getLanguage().equals(GroovyFileType.GROOVY_LANGUAGE)) {
            return null;
        }
        PsiFile file = aClass.getContainingFile();
        PsiPackage newPackage = JavaDirectoryService.getInstance().getPackage(moveDestination);
        GroovyChangeContextUtil.encodeContextInfo((PsiElement)aClass);
        PsiClass newClass = null;
        if (file instanceof GroovyFile) {
            if (((GroovyFile)file).isScript() || ((GroovyFile)file).getClasses().length > 1) {
                PsiDocComment createdDocComment;
                MoveGroovyClassHandler.correctSelfReferences(aClass, newPackage);
                PsiClass created = ((GroovyFile)GroovyTemplatesFactory.createFromTemplate(moveDestination, aClass.getName(), aClass.getName() + ".groovy", "GroovyClass.groovy", new String[0])).getClasses()[0];
                if (aClass.getDocComment() == null && (createdDocComment = created.getDocComment()) != null) {
                    aClass.addBefore((PsiElement)createdDocComment, null);
                }
                newClass = (PsiClass)created.replace((PsiElement)aClass);
                MoveGroovyClassHandler.correctOldClassReferences(newClass, aClass);
                aClass.delete();
            } else if (!moveDestination.equals(file.getContainingDirectory()) && moveDestination.findFile(file.getName()) != null) {
                MoveGroovyClassHandler.correctSelfReferences(aClass, newPackage);
                PsiFile newFile = moveDestination.findFile(file.getName());
                LeafElement enter = Factory.createSingleLeafElement((IElementType)GroovyTokenTypes.mNLS, (CharSequence)"\n", (int)0, (int)1, null, (PsiManager)aClass.getManager());
                newFile.getNode().addChild((ASTNode)enter);
                newClass = (PsiClass)newFile.add((PsiElement)aClass);
                aClass.delete();
            } else if (!moveDestination.equals(file.getContainingDirectory()) && moveDestination.findFile(file.getName()) == null && !moveDestination.equals(file.getContainingDirectory())) {
                aClass.getManager().moveFile(file, moveDestination);
                newClass = ((GroovyFile)file).getClasses()[0];
                if (newPackage != null) {
                    ((PsiClassOwner)file).setPackageName(newPackage.getQualifiedName());
                }
            }
        }
        if (newClass != null) {
            GroovyChangeContextUtil.decodeContextInfo(newClass, null, null);
        }
        return newClass;
    }

    private static void correctOldClassReferences(PsiClass newClass, PsiClass oldClass) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)oldClass, (SearchScope)new LocalSearchScope((PsiElement)newClass)).findAll()) {
            reference.bindToElement((PsiElement)newClass);
        }
    }

    private static void correctSelfReferences(PsiClass aClass, PsiPackage newContainingPackage) {
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(aClass.getContainingFile().getContainingDirectory());
        if (aPackage == null) {
            return;
        }
        for (PsiReference reference : ReferencesSearch.search((PsiElement)aClass, (SearchScope)new LocalSearchScope((PsiElement)aClass)).findAll()) {
            GrCodeReferenceElement qualifier;
            if (!(reference instanceof GrCodeReferenceElement) || (qualifier = ((GrCodeReferenceElement)reference).getQualifier()) == null) continue;
            qualifier.bindToElement((PsiElement)newContainingPackage);
        }
    }

    public String getName(PsiClass clazz) {
        PsiFile file = clazz.getContainingFile();
        if (!(file instanceof GroovyFile)) {
            return null;
        }
        return ((GroovyFile)file).getClasses().length > 1 ? clazz.getName() + "." + "groovy" : file.getName();
    }
}

