/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduceVariable;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.introduceVariable.GroovyIntroduceVariableBase;
import org.jetbrains.plugins.groovy.refactoring.introduceVariable.GroovyIntroduceVariableDialog;

public class GroovyIntroduceVariableHandler
extends GroovyIntroduceVariableBase {
    @Override
    protected void showErrorMessage(Project project, Editor editor, String message) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.introduceVariable");
    }

    @Override
    protected boolean reportConflicts(ArrayList<String> conflicts, Project project) {
        ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts);
        conflictsDialog.show();
        return conflictsDialog.isOK();
    }

    @Override
    protected GroovyIntroduceVariableDialog getDialog(Project project, Editor editor, GrExpression expr, PsiType exprType, PsiElement[] occurrences, boolean declareFinal, GroovyIntroduceVariableBase.Validator validator) {
        ArrayList highlighters = new ArrayList();
        HighlightManager highlightManager = null;
        if (editor != null) {
            highlightManager = HighlightManager.getInstance((Project)project);
            EditorColorsManager colorsManager = EditorColorsManager.getInstance();
            TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            if (occurrences.length > 1) {
                highlightManager.addOccurrenceHighlights(editor, occurrences, attributes, true, highlighters);
            }
        }
        String[] possibleNames = GroovyNameSuggestionUtil.suggestVariableNames(expr, validator);
        GroovyIntroduceVariableDialog dialog = new GroovyIntroduceVariableDialog(project, expr, exprType, occurrences.length, validator, possibleNames);
        dialog.show();
        if (!dialog.isOK()) {
            if (occurrences.length > 1) {
                WindowManager.getInstance().getStatusBar(project).setInfo(GroovyRefactoringBundle.message("press.escape.to.remove.the.highlighting", new Object[0]));
            }
        } else if (editor != null) {
            for (RangeHighlighter highlighter : highlighters) {
                highlightManager.removeSegmentHighlighter(editor, highlighter);
            }
        }
        return dialog;
    }

    @Override
    protected void highlightOccurrences(Project project, Editor editor, PsiElement[] elements) {
        GroovyRefactoringUtil.highlightOccurrences(project, editor, elements);
    }
}

