/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.surroundWith.surrounders;

import com.intellij.lang.ASTNode;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;

public abstract class GroovyManyStatementsSurrounder
implements Surrounder {
    public boolean isStatements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/surroundWith/surrounders/GroovyManyStatementsSurrounder.isStatements must not be null");
        }
        for (PsiElement element : elements) {
            if (element instanceof GrStatement) continue;
            return false;
        }
        return true;
    }

    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/surroundWith/surrounders/GroovyManyStatementsSurrounder.isApplicable must not be null");
        }
        if (elements.length == 0) {
            return false;
        }
        if (elements.length == 1) {
            return elements[0] instanceof GrStatement && !(elements[0] instanceof GrBlockStatement);
        }
        return this.isStatements(elements);
    }

    protected String getListElementsTemplateAsString(PsiElement ... elements) {
        StringBuffer result = new StringBuffer();
        for (PsiElement element : elements) {
            result.append(element.getText());
            result.append("\n");
        }
        return result.toString();
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/surroundWith/surrounders/GroovyManyStatementsSurrounder.surroundElements must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/surroundWith/surrounders/GroovyManyStatementsSurrounder.surroundElements must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/surroundWith/surrounders/GroovyManyStatementsSurrounder.surroundElements must not be null");
        }
        if (elements.length == 0) {
            return null;
        }
        PsiElement element1 = elements[0];
        GroovyPsiElement newStmt = this.doSurroundElements(elements);
        assert (newStmt != null);
        ASTNode parentNode = element1.getParent().getNode();
        for (int i = 0; i < elements.length; ++i) {
            PsiElement newLine;
            PsiElement element = elements[i];
            if (i == 0) {
                parentNode.replaceChild(element1.getNode(), newStmt.getNode());
                continue;
            }
            if (parentNode != element.getParent().getNode()) {
                return null;
            }
            int endOffset = element.getTextRange().getEndOffset();
            PsiElement semicolon = PsiTreeUtil.findElementOfClassAtRange((PsiFile)element.getContainingFile(), (int)endOffset, (int)(endOffset + 1), PsiElement.class);
            if (semicolon != null && ";".equals(semicolon.getText())) {
                assert (parentNode == semicolon.getParent().getNode());
                parentNode.removeChild(semicolon.getNode());
            }
            if (i < elements.length - 1 && (newLine = PsiTreeUtil.findElementOfClassAtRange((PsiFile)element.getContainingFile(), (int)endOffset, (int)elements[i + 1].getTextRange().getStartOffset(), PsiElement.class)) != null && GroovyElementTypes.mNLS.equals(newLine.getNode().getElementType())) {
                assert (parentNode == newLine.getParent().getNode());
                parentNode.removeChild(newLine.getNode());
            }
            parentNode.removeChild(element.getNode());
        }
        return this.getSurroundSelectionRange(newStmt);
    }

    protected void addStatements(GrCodeBlock block, PsiElement[] elements) throws IncorrectOperationException {
        for (int i = 0; i < elements.length; ++i) {
            PsiElement element = elements[i];
            GrStatement statement = (GrStatement)element;
            block.addStatementBefore(statement, null);
        }
    }

    protected abstract GroovyPsiElement doSurroundElements(PsiElement[] var1) throws IncorrectOperationException;

    protected abstract TextRange getSurroundSelectionRange(GroovyPsiElement var1);
}

