/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs;

import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GrStubUtils {
    public static List<Set<String>> deserializeCollectionsArray(StubInputStream dataStream) throws IOException {
        int namedParametersSetNumber = dataStream.readByte();
        ArrayList<Set<String>> collArray = new ArrayList<Set<String>>();
        for (int i = 0; i < namedParametersSetNumber; ++i) {
            int curNamedParameterSetSize = dataStream.readByte();
            String[] namedParameterSetArray = new String[curNamedParameterSetSize];
            for (int j = 0; j < curNamedParameterSetSize; ++j) {
                namedParameterSetArray[j] = dataStream.readUTF();
            }
            HashSet<String> curSet = new HashSet<String>();
            curSet.addAll(Arrays.asList(namedParameterSetArray));
            collArray.add(curSet);
        }
        return collArray;
    }

    public static void serializeCollectionsArray(StubOutputStream dataStream, Set<String>[] collArray) throws IOException {
        dataStream.writeByte(collArray.length);
        for (Set<String> namedParameterSet : collArray) {
            dataStream.writeByte(namedParameterSet.size());
            for (String namepParameter : namedParameterSet) {
                dataStream.writeUTF(namepParameter);
            }
        }
    }
}

