/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.types;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReferenceElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.CompletionProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class GrCodeReferenceElementImpl
extends GrReferenceElementImpl
implements GrCodeReferenceElement {
    private static final OurResolver RESOLVER = new OurResolver();

    public GrCodeReferenceElementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    protected PsiElement bindWithQualifiedRef(String qName) {
        GrTypeArgumentList list = this.getTypeArgumentList();
        String typeArgs = list != null ? list.getText() : "";
        String text = qName + typeArgs;
        GrCodeReferenceElement qualifiedRef = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeOrPackageReference(text);
        this.getNode().getTreeParent().replaceChild(this.getNode(), qualifiedRef.getNode());
        PsiUtil.shortenReference(qualifiedRef);
        return qualifiedRef;
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitCodeReferenceElement(this);
    }

    public String toString() {
        return "Reference element";
    }

    @Override
    public GrCodeReferenceElement getQualifier() {
        return (GrCodeReferenceElement)this.findChildByType(GroovyElementTypes.REFERENCE_ELEMENT);
    }

    @Override
    public void setQualifier(@Nullable GrCodeReferenceElement newQualifier) {
        GrCodeReferenceElement qualifier = this.getQualifier();
        if (newQualifier == null) {
            if (qualifier == null) {
                return;
            }
            this.getNode().removeRange(this.getNode().getFirstChildNode(), this.getReferenceNameElement().getNode());
        } else if (qualifier == null) {
            ASTNode refNameNode = this.getReferenceNameElement().getNode();
            this.getNode().addChild(newQualifier.getNode(), refNameNode);
            this.getNode().addLeaf(GroovyTokenTypes.mDOT, (CharSequence)".", refNameNode);
        } else {
            this.getNode().replaceChild(qualifier.getNode(), newQualifier.getNode());
        }
    }

    @Override
    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.getManager().getResolveCache().resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)RESOLVER, true, false);
        return results.length == 1 ? results[0].getElement() : null;
    }

    private ReferenceKind getKind(boolean forCompletion) {
        if (this.isClassReferenceForNew()) {
            return ReferenceKind.CLASS_OR_PACKAGE;
        }
        PsiElement parent = this.getParent();
        if (parent instanceof GrCodeReferenceElement) {
            ReferenceKind parentKind = ((GrCodeReferenceElementImpl)parent).getKind(forCompletion);
            if (parentKind == ReferenceKind.CLASS) {
                return ReferenceKind.CLASS_OR_PACKAGE;
            }
            if (parentKind == ReferenceKind.STATIC_MEMBER_FQ) {
                return ReferenceKind.CLASS_FQ;
            }
            if (parentKind == ReferenceKind.CLASS_FQ) {
                return ReferenceKind.CLASS_OR_PACKAGE_FQ;
            }
            return parentKind;
        }
        if (parent instanceof GrPackageDefinition) {
            return ReferenceKind.PACKAGE_FQ;
        }
        if (parent instanceof GrDocReferenceElement) {
            return ReferenceKind.CLASS_OR_PACKAGE;
        }
        if (parent instanceof GrImportStatement) {
            GrImportStatement importStatement = (GrImportStatement)parent;
            if (importStatement.isStatic()) {
                return importStatement.isOnDemand() ? ReferenceKind.CLASS : ReferenceKind.STATIC_MEMBER_FQ;
            }
            return forCompletion || importStatement.isOnDemand() ? ReferenceKind.CLASS_OR_PACKAGE_FQ : ReferenceKind.CLASS_FQ;
        }
        if (parent instanceof GrNewExpression || parent instanceof GrAnonymousClassDefinition) {
            if (parent instanceof GrAnonymousClassDefinition) {
                parent = parent.getParent();
            }
            assert (parent instanceof GrNewExpression);
            GrNewExpression newExpression = (GrNewExpression)parent;
            if (newExpression.getQualifier() != null) {
                return ReferenceKind.CLASS_IN_QUALIFIED_NEW;
            }
        }
        return ReferenceKind.CLASS;
    }

    @Nullable
    public String getCanonicalText() {
        String qualifierText;
        GrCodeReferenceElement qualifier;
        PsiElement resolved = this.resolve();
        if (resolved instanceof PsiClass) {
            return ((PsiClass)resolved).getQualifiedName();
        }
        if (resolved instanceof PsiPackage) {
            return ((PsiPackage)resolved).getQualifiedName();
        }
        if (this.getKind(false) == ReferenceKind.STATIC_MEMBER_FQ && (qualifier = this.getQualifier()) != null && (qualifierText = qualifier.getCanonicalText()) != null) {
            return qualifierText + "." + this.getReferenceName();
        }
        return null;
    }

    @Override
    protected boolean bindsCorrectly(PsiElement element) {
        PsiMethod method;
        PsiElement resolved;
        if (super.bindsCorrectly(element)) {
            return true;
        }
        return element instanceof PsiClass && (resolved = this.resolve()) instanceof PsiMethod && (method = (PsiMethod)resolved).isConstructor() && this.getManager().areElementsEquivalent(element, (PsiElement)method.getContainingClass());
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.getManager().areElementsEquivalent(element, this.resolve());
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl.getVariants must not return null");
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private boolean isClassReferenceForNew() {
        PsiElement parent = this.getParent();
        while (parent instanceof GrCodeReferenceElement) {
            parent = parent.getParent();
        }
        return parent instanceof GrNewExpression;
    }

    /*
     * WARNING - void declaration
     */
    private void processVariantsImpl(ReferenceKind kind, Consumer<Object> consumer) {
        switch (kind) {
            case STATIC_MEMBER_FQ: {
                PsiElement resolve;
                GrCodeReferenceElement qualifier = this.getQualifier();
                if (qualifier != null && (resolve = qualifier.resolve()) instanceof PsiClass) {
                    PsiClass clazz = (PsiClass)resolve;
                    for (PsiField psiField : clazz.getFields()) {
                        if (!psiField.hasModifierProperty("static")) continue;
                        consumer.consume((Object)psiField);
                    }
                    for (PsiField psiField : clazz.getMethods()) {
                        if (!psiField.hasModifierProperty("static")) continue;
                        consumer.consume((Object)psiField);
                    }
                    return;
                }
            }
            case PACKAGE_FQ: 
            case CLASS_FQ: 
            case CLASS_OR_PACKAGE_FQ: {
                String refText = PsiUtil.getQualifiedReferenceText(this);
                int lastDot = refText.lastIndexOf(".");
                String parentPackageFQName = lastDot > 0 ? refText.substring(0, lastDot) : "";
                PsiPackage parentPackage = JavaPsiFacade.getInstance((Project)this.getProject()).findPackage(parentPackageFQName);
                if (parentPackage != null) {
                    GlobalSearchScope scope = this.getResolveScope();
                    if (kind == ReferenceKind.PACKAGE_FQ) {
                        for (PsiPackage aPackage : parentPackage.getSubPackages(scope)) {
                            consumer.consume((Object)aPackage);
                        }
                        return;
                    }
                    if (kind == ReferenceKind.CLASS_FQ) {
                        for (PsiClass aClass : parentPackage.getClasses(scope)) {
                            consumer.consume((Object)aClass);
                        }
                        return;
                    }
                    PsiPackage[] subpackages = parentPackage.getSubPackages(scope);
                    PsiClass[] psiClassArray = parentPackage.getClasses(scope);
                    for (PsiPackage psiPackage : subpackages) {
                        consumer.consume((Object)psiPackage);
                    }
                    for (PsiPackage psiPackage : psiClassArray) {
                        consumer.consume((Object)psiPackage);
                    }
                    return;
                }
            }
            case CLASS_OR_PACKAGE: 
            case CLASS_IN_QUALIFIED_NEW: 
            case CLASS: {
                GrCodeReferenceElement qualifier = this.getQualifier();
                if (qualifier != null) {
                    PsiElement qualifierResolved = qualifier.resolve();
                    if (qualifierResolved instanceof PsiPackage) {
                        PsiPackage[] subpackages;
                        void var9_34;
                        PsiClass[] classes;
                        PsiPackage aPackage = (PsiPackage)qualifierResolved;
                        PsiClass[] arr$ = classes = aPackage.getClasses(this.getResolveScope());
                        int len$ = arr$.length;
                        boolean bl = false;
                        while (var9_34 < len$) {
                            PsiClass aClass = arr$[var9_34];
                            consumer.consume((Object)aClass);
                            ++var9_34;
                        }
                        if (kind == ReferenceKind.CLASS) {
                            return;
                        }
                        for (PsiPackage subpackage : subpackages = aPackage.getSubPackages()) {
                            consumer.consume((Object)subpackage);
                        }
                    } else {
                        if (!(qualifierResolved instanceof PsiClass)) break;
                        for (PsiClass aClass : ((PsiClass)qualifierResolved).getInnerClasses()) {
                            consumer.consume((Object)aClass);
                        }
                    }
                } else {
                    ResolverProcessor classProcessor = CompletionProcessor.createClassCompletionProcessor(this);
                    ResolveUtil.treeWalkUp(this, classProcessor, false);
                    for (Object o : GroovyCompletionUtil.getCompletionVariants(classProcessor.getCandidates())) {
                        consumer.consume(o);
                    }
                }
                break;
            }
        }
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    public GroovyResolveResult advancedResolve() {
        ResolveResult[] results = this.getManager().getResolveCache().resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)RESOLVER, true, false);
        return results.length == 1 ? (GroovyResolveResult)results[0] : GroovyResolveResult.EMPTY_RESULT;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        GroovyResolveResult[] groovyResolveResultArray;
        ResolveResult[] results = this.getManager().getResolveCache().resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)RESOLVER, true, incompleteCode);
        if (results.length == 0) {
            groovyResolveResultArray = GroovyResolveResult.EMPTY_ARRAY;
            if (GroovyResolveResult.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl.multiResolve must not return null");
            return groovyResolveResultArray;
        }
        groovyResolveResultArray = (GroovyResolveResult[])results;
        if (groovyResolveResultArray != null) return groovyResolveResultArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/types/GrCodeReferenceElementImpl.multiResolve must not return null");
    }

    @Override
    public void processVariants(Consumer<Object> consumer) {
        this.processVariantsImpl(this.getKind(true), consumer);
    }

    private static class OurResolver
    implements ResolveCache.PolyVariantResolver<GrCodeReferenceElementImpl> {
        private OurResolver() {
        }

        public GroovyResolveResult[] resolve(GrCodeReferenceElementImpl reference, boolean incompleteCode) {
            if (reference.getReferenceName() == null) {
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            GroovyResolveResult[] results = OurResolver._resolve(reference, (PsiManager)reference.getManager(), reference.getKind(false));
            PsiType[] args = reference.getTypeArguments();
            for (int i = 0; i < results.length; ++i) {
                GroovyResolveResult result = results[i];
                PsiElement element = result.getElement();
                if (!(element instanceof PsiClass)) continue;
                PsiSubstitutor substitutor = result.getSubstitutor();
                PsiSubstitutor newSubstitutor = substitutor.putAll((PsiClass)element, args);
                results[i] = new GroovyResolveResultImpl(element, result.getCurrentFileResolveContext(), newSubstitutor, result.isAccessible(), result.isStaticsOK());
            }
            return results;
        }

        /*
         * WARNING - void declaration
         */
        private static GroovyResolveResult[] _resolve(GrCodeReferenceElementImpl ref, PsiManager manager, ReferenceKind kind) {
            String refName = ref.getReferenceName();
            if (refName == null) {
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            switch (kind) {
                case PACKAGE_FQ: 
                case CLASS_FQ: 
                case CLASS_OR_PACKAGE_FQ: {
                    PsiPackage aPackage;
                    String qName = PsiUtil.getQualifiedReferenceText(ref);
                    JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
                    if (kind == ReferenceKind.CLASS_OR_PACKAGE_FQ || kind == ReferenceKind.CLASS_FQ) {
                        PsiClass aClass;
                        PsiFile file = ref.getContainingFile();
                        if ((qName.indexOf(46) > 0 || file instanceof GroovyFile && ((GroovyFile)file).getPackageName().length() == 0) && (aClass = facade.findClass(qName, ref.getResolveScope())) != null) {
                            boolean isAccessible = PsiUtil.isAccessible(ref, (PsiMember)aClass);
                            return new GroovyResolveResult[]{new GroovyResolveResultImpl((PsiElement)aClass, isAccessible)};
                        }
                    }
                    if (kind != ReferenceKind.CLASS_OR_PACKAGE_FQ && kind != ReferenceKind.PACKAGE_FQ || (aPackage = facade.findPackage(qName)) == null) break;
                    return new GroovyResolveResult[]{new GroovyResolveResultImpl((PsiElement)aPackage, true)};
                }
                case CLASS_OR_PACKAGE: 
                case CLASS: {
                    GrCodeReferenceElement qualifier = ref.getQualifier();
                    if (qualifier != null) {
                        PsiElement qualifierResolved = qualifier.resolve();
                        if (qualifierResolved instanceof PsiPackage) {
                            for (PsiClass psiClass : ((PsiPackage)qualifierResolved).getClasses(ref.getResolveScope())) {
                                if (!refName.equals(psiClass.getName())) continue;
                                boolean isAccessible = PsiUtil.isAccessible(ref, (PsiMember)psiClass);
                                return new GroovyResolveResult[]{new GroovyResolveResultImpl((PsiElement)psiClass, isAccessible)};
                            }
                            if (kind != ReferenceKind.CLASS_OR_PACKAGE) break;
                            for (PsiClass psiClass : ((PsiPackage)qualifierResolved).getSubPackages()) {
                                if (!refName.equals(psiClass.getName())) continue;
                                return new GroovyResolveResult[]{new GroovyResolveResultImpl((PsiElement)psiClass, true)};
                            }
                        } else {
                            void var11_35;
                            PsiClass[] classes;
                            if (kind != ReferenceKind.CLASS && kind != ReferenceKind.CLASS_OR_PACKAGE || !(qualifierResolved instanceof PsiClass)) break;
                            PsiClass[] arr$ = classes = ((PsiClass)qualifierResolved).getAllInnerClasses();
                            int len$ = arr$.length;
                            boolean bl = false;
                            while (var11_35 < len$) {
                                PsiClass aClass = arr$[var11_35];
                                if (refName.equals(aClass.getName())) {
                                    boolean isAccessible = PsiUtil.isAccessible(ref, (PsiMember)aClass);
                                    return new GroovyResolveResult[]{new GroovyResolveResultImpl((PsiElement)aClass, isAccessible)};
                                }
                                ++var11_35;
                            }
                        }
                    } else {
                        PsiPackage defaultPackage;
                        EnumSet<ClassHint.ResolveKind> kinds = kind == ReferenceKind.CLASS ? EnumSet.of(ClassHint.ResolveKind.CLASS) : EnumSet.of(ClassHint.ResolveKind.PACKAGE, ClassHint.ResolveKind.CLASS);
                        ClassResolverProcessor processor = new ClassResolverProcessor(refName, ref, kinds);
                        ResolveUtil.treeWalkUp(ref, processor, false);
                        GroovyResolveResult[] candidates = processor.getCandidates();
                        if (candidates.length > 0) {
                            return candidates;
                        }
                        if (kind != ReferenceKind.CLASS_OR_PACKAGE || (defaultPackage = JavaPsiFacade.getInstance((Project)ref.getProject()).findPackage("")) == null) break;
                        for (PsiPackage subpackage : defaultPackage.getSubPackages()) {
                            if (!refName.equals(subpackage.getName())) continue;
                            return new GroovyResolveResult[]{new GroovyResolveResultImpl((PsiElement)subpackage, true)};
                        }
                    }
                    break;
                }
                case STATIC_MEMBER_FQ: {
                    PsiMethod[] methods;
                    PsiElement resolve;
                    GrCodeReferenceElement qualifier = ref.getQualifier();
                    if (qualifier == null || !((resolve = qualifier.resolve()) instanceof PsiClass)) break;
                    PsiClass clazz = (PsiClass)resolve;
                    PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)clazz.getProject()).getResolveHelper();
                    ArrayList<GroovyResolveResultImpl> result = new ArrayList<GroovyResolveResultImpl>();
                    PsiField psiField = clazz.findFieldByName(refName, false);
                    if (psiField != null && psiField.hasModifierProperty("static")) {
                        result.add(new GroovyResolveResultImpl((PsiElement)psiField, helper.isAccessible((PsiMember)psiField, (PsiElement)ref, null)));
                    }
                    for (PsiMethod method : methods = clazz.findMethodsByName(refName, false)) {
                        result.add(new GroovyResolveResultImpl((PsiElement)method, helper.isAccessible((PsiMember)method, (PsiElement)ref, null)));
                    }
                    return result.toArray(new GroovyResolveResult[result.size()]);
                }
                case CLASS_IN_QUALIFIED_NEW: {
                    PsiClassType classType;
                    PsiClass psiClass;
                    if (ref.getParent() instanceof GrCodeReferenceElement) {
                        return GroovyResolveResult.EMPTY_ARRAY;
                    }
                    GrNewExpression newExpression = (GrNewExpression)PsiTreeUtil.getParentOfType((PsiElement)ref, GrNewExpression.class);
                    assert (newExpression != null);
                    GrExpression qualifier = newExpression.getQualifier();
                    assert (qualifier != null);
                    PsiType type = qualifier.getType();
                    if (!(type instanceof PsiClassType) || (psiClass = (classType = (PsiClassType)type).resolve()) == null) break;
                    PsiClass[] psiClassArray = psiClass.getAllInnerClasses();
                    ArrayList<GroovyResolveResultImpl> result = new ArrayList<GroovyResolveResultImpl>();
                    PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)ref.getProject()).getResolveHelper();
                    for (PsiClass innerClass : psiClassArray) {
                        if (!refName.equals(innerClass.getName())) continue;
                        result.add(new GroovyResolveResultImpl((PsiElement)innerClass, helper.isAccessible((PsiMember)innerClass, (PsiElement)ref, null)));
                    }
                    return result.toArray(new GroovyResolveResult[result.size()]);
                }
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }
    }

    static enum ReferenceKind {
        CLASS,
        CLASS_OR_PACKAGE,
        PACKAGE_FQ,
        CLASS_FQ,
        CLASS_OR_PACKAGE_FQ,
        STATIC_MEMBER_FQ,
        CLASS_IN_QUALIFIED_NEW;

    }
}

