/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReceiver;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.source.HierarchicalMethodSignatureImpl;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.ui.RowIcon;
import java.util.LinkedHashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.LightModifierList;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.LightParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.LightParameterList;

public class GrGdkMethodImpl
extends LightMethod
implements GrGdkMethod {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrGdkMethodImpl");
    private final PsiMethod myMethod;
    private LightParameterList myParameterList = null;
    private final LightModifierList myModifierList;

    @NotNull
    public Language getLanguage() {
        Language language = GroovyFileType.GROOVY_FILE_TYPE.getLanguage();
        if (language == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrGdkMethodImpl.getLanguage must not return null");
        }
        return language;
    }

    public boolean isValid() {
        return true;
    }

    public GrGdkMethodImpl(PsiMethod method, boolean isStatic) {
        super(method.getManager(), method, null);
        this.myMethod = method;
        final PsiManager manager = method.getManager();
        LinkedHashSet<String> modifiers = new LinkedHashSet<String>();
        modifiers.add("public");
        if (isStatic) {
            modifiers.add("static");
        }
        this.myModifierList = new LightModifierList(manager, modifiers);
        final PsiParameter[] originalParameters = method.getParameterList().getParameters();
        final String[] parmNames = new String[originalParameters.length - 1];
        for (int i = 1; i < originalParameters.length; ++i) {
            PsiParameter originalParameter = originalParameters[i];
            PsiType type = originalParameter.getType();
            String[] nameSuggestions = JavaCodeStyleManager.getInstance((Project)this.getProject()).suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)type).names;
            String baseName = nameSuggestions.length > 0 ? nameSuggestions[0] : "p";
            int postfix = 1;
            String name = baseName;
            while (true) {
                for (int j = 1; j < i; ++j) {
                    if (!name.equals(parmNames[j - 1])) continue;
                    name = baseName + postfix;
                    ++postfix;
                }
                break;
            }
            parmNames[i - 1] = name;
        }
        this.myParameterList = new LightParameterList(manager, new Computable<LightParameter[]>(){

            public LightParameter[] compute() {
                LightParameter[] result = new LightParameter[parmNames.length];
                for (int i = 0; i < result.length; ++i) {
                    PsiParameter parameter = originalParameters[i + 1];
                    LOG.assertTrue(parameter.isValid());
                    result[i] = new LightParameter(manager, parmNames[i], null, parameter.getType(), (PsiElement)GrGdkMethodImpl.this);
                }
                return result;
            }
        });
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignatureImpl hierarchicalMethodSignatureImpl = new HierarchicalMethodSignatureImpl((MethodSignatureBackedByPsiMethod)this.getSignature(PsiSubstitutor.EMPTY));
        if (hierarchicalMethodSignatureImpl == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrGdkMethodImpl.getHierarchicalMethodSignature must not return null");
        }
        return hierarchicalMethodSignatureImpl;
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrGdkMethodImpl.getSignature must not be null");
        }
        MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)substitutor);
        if (methodSignatureBackedByPsiMethod == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrGdkMethodImpl.getSignature must not return null");
        }
        return methodSignatureBackedByPsiMethod;
    }

    @Override
    public PsiMethod getStaticMethod() {
        return this.myMethod;
    }

    @NotNull
    public PsiParameterList getParameterList() {
        LightParameterList lightParameterList = this.myParameterList;
        if (lightParameterList == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrGdkMethodImpl.getParameterList must not return null");
        }
        return lightParameterList;
    }

    @NotNull
    public PsiModifierList getModifierList() {
        LightModifierList lightModifierList = this.myModifierList;
        if (lightModifierList == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrGdkMethodImpl.getModifierList must not return null");
        }
        return lightModifierList;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrGdkMethodImpl.hasModifierProperty must not be null");
        }
        return this.myModifierList.hasModifierProperty(name);
    }

    public boolean canNavigate() {
        return this.myMethod.canNavigate();
    }

    public boolean isConstructor() {
        return false;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.myMethod.getNavigationElement();
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrGdkMethodImpl.getNavigationElement must not return null");
        }
        return psiElement;
    }

    public void navigate(boolean requestFocus) {
        this.myMethod.navigate(requestFocus);
    }

    public PsiMethodReceiver getMethodReceiver() {
        return null;
    }

    public Icon getIcon(int flags) {
        RowIcon baseIcon = GrGdkMethodImpl.createLayeredIcon((Icon)GroovyIcons.METHOD, (int)ElementPresentationUtil.getFlags((PsiModifierListOwner)this, (boolean)false));
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, (int)flags, (RowIcon)baseIcon);
    }
}

