/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiType;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrSyntheticMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.LightParameter;

public class GrAccessorMethodImpl
extends GrSyntheticMethod
implements GrAccessorMethod {
    public static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrAccessorMethodImpl");
    @NotNull
    private final GrField myProperty;
    private final boolean myIsSetter;

    public GrAccessorMethodImpl(@NotNull GrField property, boolean isSetter, String name) {
        if (property == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrAccessorMethodImpl.<init> must not be null");
        }
        super(property.getManager(), name);
        this.myProperty = property;
        this.myIsSetter = isSetter;
    }

    @Nullable
    public PsiType getReturnType() {
        if (this.myIsSetter) {
            return PsiType.VOID;
        }
        return this.myProperty.getType();
    }

    @Override
    @Nullable
    public PsiType getReturnTypeGroovy() {
        if (this.myIsSetter) {
            return PsiType.VOID;
        }
        return this.myProperty.getDeclaredType();
    }

    @Override
    protected LightParameter[] getParameters() {
        if (this.myIsSetter) {
            PsiType type = this.myProperty.getDeclaredType();
            if (type == null) {
                type = TypesUtil.getJavaLangObject(this.myProperty);
            }
            return new LightParameter[]{new LightParameter(this.getManager(), this.myProperty.getName(), null, type, (PsiElement)this)};
        }
        return LightParameter.EMPTY_ARRAY;
    }

    @Nullable
    public PsiIdentifier getNameIdentifier() {
        return this.myProperty.getNameIdentifier();
    }

    @Override
    protected Set<String> getModifiers() {
        LinkedHashSet<String> modifiers = new LinkedHashSet<String>();
        modifiers.add("public");
        GrModifierList original = this.myProperty.getModifierList();
        assert (original != null);
        if (original.hasExplicitModifier("static")) {
            modifiers.add("static");
        }
        if (original.hasExplicitModifier("abstract")) {
            modifiers.add("abstract");
        }
        if (original.hasExplicitModifier("final")) {
            modifiers.add("final");
        }
        return modifiers;
    }

    public PsiClass getContainingClass() {
        return this.myProperty.getContainingClass();
    }

    public int getTextOffset() {
        return this.myProperty.getTextOffset();
    }

    public PsiElement copy() {
        String modifiers = this.getModifierList().getText();
        String params = this.myIsSetter ? "(" + this.myProperty.getName() + ")" : "()";
        return GroovyPsiElementFactory.getInstance(this.getProject()).createMethodFromText(modifiers + " " + this.getName() + params + "{}");
    }

    public PsiFile getContainingFile() {
        return this.myProperty.getContainingFile();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        GrField grField = this.myProperty;
        if (grField == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrAccessorMethodImpl.getNavigationElement must not return null");
        }
        return grField;
    }

    public String toString() {
        return "AccessorMethod";
    }

    public boolean isValid() {
        return this.myProperty.isValid();
    }

    @Override
    @NotNull
    public GrField getProperty() {
        GrField grField = this.myProperty;
        if (grField == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrAccessorMethodImpl.getProperty must not return null");
        }
        return grField;
    }

    public PsiElement getContext() {
        return this.myProperty;
    }

    public Icon getIcon(int flags) {
        return GroovyIcons.PROPERTY;
    }
}

