/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.arithmetic;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrUnaryExpressionImpl
extends GrExpressionImpl
implements GrUnaryExpression {
    private static final String PATTERN_FQ_NAME = "java.util.regex.Pattern";

    public GrUnaryExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/arithmetic/GrUnaryExpressionImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public String toString() {
        return "Unary expression";
    }

    @Override
    public PsiType getType() {
        IElementType opToken = this.getOperationTokenType();
        GrExpression operand = this.getOperand();
        if (operand == null) {
            return null;
        }
        if (opToken == GroovyTokenTypes.mINC || opToken == GroovyTokenTypes.mDEC) {
            return TypesUtil.getTypeForIncOrDecExpression(this);
        }
        PsiType opType = operand.getType();
        if (opType == null) {
            return null;
        }
        if (opToken == GroovyTokenTypes.mBNOT && opType.equalsToText("java.lang.String")) {
            return this.getTypeByFQName(PATTERN_FQ_NAME);
        }
        return opType;
    }

    @Override
    public IElementType getOperationTokenType() {
        PsiElement opElement = this.findChildByType(GroovyTokenTypes.UNARY_OP_SET);
        assert (opElement != null);
        ASTNode node = opElement.getNode();
        assert (node != null);
        return node.getElementType();
    }

    @Override
    public GrExpression getOperand() {
        return (GrExpression)this.findChildByClass(GrExpression.class);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitUnaryExpression(this);
    }
}

