/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.arguments;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.PropertyResolverProcessor;

public class GrArgumentLabelImpl
extends GroovyPsiElementImpl
implements GrArgumentLabel {
    public GrArgumentLabelImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitArgumentLabel(this);
    }

    public String toString() {
        return "Argument label";
    }

    public PsiReference getReference() {
        Object[] otherReferences = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, GrArgumentLabel.class);
        Object[] thisReference = new PsiReference[]{this};
        return new PsiMultiReference((PsiReference[])(otherReferences.length == 0 ? thisReference : (PsiReference[])ArrayUtil.mergeArrays((Object[])thisReference, (Object[])otherReferences, PsiReference.class)), (PsiElement)this);
    }

    @Override
    @Nullable
    public String getName() {
        Object value;
        PsiElement element = this.getNameElement();
        if (element instanceof GrLiteral && (value = ((GrLiteral)element).getValue()) instanceof String) {
            return (String)value;
        }
        if (element instanceof GrExpression && (value = JavaPsiFacade.getInstance((Project)this.getProject()).getConstantEvaluationHelper().computeConstantExpression(element)) instanceof String) {
            return (String)value;
        }
        IElementType elemType = element.getNode().getElementType();
        if (GroovyTokenTypes.mIDENT == elemType) {
            return element.getText();
        }
        if ("java.lang.String".equals(TypesUtil.getPsiTypeName(elemType))) {
            return GrStringUtil.removeQuotes(element.getText());
        }
        return null;
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @Nullable
    public PsiElement resolve() {
        String propName = this.getText();
        String setterName = PropertyUtil.suggestSetterName((String)propName);
        PsiElement context = this.getParent().getParent();
        if (context instanceof GrArgumentList) {
            PsiParameter[] parameters;
            PsiMethod resolvedMethod;
            PsiElement parent = context.getParent();
            if (parent instanceof GrCallExpression && (resolvedMethod = ((GrCallExpression)parent).resolveMethod()) != null && (parameters = resolvedMethod.getParameterList().getParameters()).length > 0 && PsiUtil.createMapType(resolvedMethod.getManager(), resolvedMethod.getResolveScope()).isAssignableFrom(parameters[0].getType())) {
                return null;
            }
            if (parent instanceof GrExpression || parent instanceof GrAnonymousClassDefinition) {
                PsiClass clazz;
                PsiType type;
                Object object = type = parent instanceof GrExpression ? ((GrExpression)parent).getType() : ((GrAnonymousClassDefinition)parent).getBaseClassType();
                if (type instanceof PsiClassType && (clazz = ((PsiClassType)type).resolve()) != null) {
                    PsiMethod[] byName = clazz.findMethodsByName(setterName, true);
                    if (byName.length > 0) {
                        return byName[0];
                    }
                    PsiField field = clazz.findFieldByName(propName, true);
                    if (field != null) {
                        return field;
                    }
                    PropertyResolverProcessor processor = new PropertyResolverProcessor(propName, this);
                    ResolveUtil.processNonCodeMethods((PsiType)JavaPsiFacade.getElementFactory((Project)this.getProject()).createType(clazz), processor, this.getProject(), this, false);
                    GroovyResolveResult[] candidates = processor.getCandidates();
                    if (candidates.length == 0) {
                        return null;
                    }
                    return candidates[0].getElement();
                }
            }
        }
        return null;
    }

    public String getCanonicalText() {
        String qName;
        PsiClass clazz;
        PsiElement resolved = this.resolve();
        if (resolved instanceof PsiMember && resolved instanceof PsiNamedElement && (clazz = ((PsiMember)resolved).getContainingClass()) != null && (qName = clazz.getQualifiedName()) != null) {
            return qName + "." + ((PsiNamedElement)resolved).getName();
        }
        return this.getText();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiElement resolved = this.resolve();
        if (resolved instanceof PsiMethod) {
            String newPropertyName;
            PsiMethod method = (PsiMethod)resolved;
            String oldName = this.getNameElement().getText();
            if (!method.getName().equals(oldName) && PropertyUtil.isSimplePropertySetter((PsiMethod)method) && (newPropertyName = PropertyUtil.getPropertyName((String)newElementName)) != null) {
                return this.doHandleElementRename(newPropertyName);
            }
        }
        return this.doHandleElementRename(newElementName);
    }

    private PsiElement doHandleElementRename(String newElementName) {
        PsiElement nameElement = this.getNameElement();
        ASTNode node = nameElement.getNode();
        ASTNode newNameNode = GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceNameFromText(newElementName).getNode();
        assert (newNameNode != null && node != null);
        node.getTreeParent().replaceChild(node, newNameNode);
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelImpl.bindToElement must not be null");
        }
        throw new IncorrectOperationException("NIY");
    }

    public boolean isReferenceTo(PsiElement element) {
        return (element instanceof PsiMethod || element instanceof PsiField) && this.getManager().areElementsEquivalent(element, this.resolve());
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelImpl.getVariants must not return null");
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @NotNull
    public PsiElement getNameElement() {
        PsiElement element = this.getFirstChild();
        assert (element != null);
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentLabelImpl.getNameElement must not return null");
        }
        return psiElement;
    }

    @Override
    @Nullable
    public PsiType getExpectedArgumentType() {
        PsiElement resolved = this.resolve();
        if (resolved instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolved;
            if (PropertyUtil.isSimplePropertyGetter((PsiMethod)method)) {
                return method.getReturnType();
            }
            if (PropertyUtil.isSimplePropertySetter((PsiMethod)method)) {
                return method.getParameterList().getParameters()[0].getType();
            }
        } else if (resolved instanceof PsiField) {
            return ((PsiField)resolved).getType();
        }
        return null;
    }

    @Override
    public PsiType getLabelType() {
        PsiElement el = this.getNameElement();
        if (el instanceof GrParenthesizedExpression) {
            return ((GrParenthesizedExpression)el).getType();
        }
        ASTNode node = el.getNode();
        if (node == null) {
            return null;
        }
        PsiType nodeType = TypesUtil.getPsiType(el, node.getElementType());
        if (nodeType != null) {
            return nodeType;
        }
        return PsiType.getJavaLangString((PsiManager)PsiManager.getInstance((Project)el.getProject()), (GlobalSearchScope)el.getResolveScope());
    }

    @Override
    public GrNamedArgument getNamedArgument() {
        PsiElement parent = this.getParent();
        assert (parent instanceof GrNamedArgument);
        return (GrNamedArgument)parent;
    }
}

