/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;

public class GrTupleType
extends GrLiteralClassType {
    private final PsiType[] myComponentTypes;

    public GrTupleType(PsiType[] componentTypes, JavaPsiFacade facade, GlobalSearchScope scope) {
        this(componentTypes, facade, scope, LanguageLevel.JDK_1_5);
    }

    public GrTupleType(PsiType[] componentTypes, JavaPsiFacade facade, GlobalSearchScope scope, LanguageLevel languageLevel) {
        super(languageLevel, scope, facade);
        this.myComponentTypes = componentTypes;
    }

    @Override
    protected String getJavaClassName() {
        return "java.util.List";
    }

    public String getClassName() {
        return "List";
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiType[] getParameters() {
        PsiType[] psiTypeArray;
        if (this.myComponentTypes.length == 0) {
            psiTypeArray = PsiType.EMPTY_ARRAY;
            if (PsiType.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType.getParameters must not return null");
            return psiTypeArray;
        }
        psiTypeArray = new PsiType[]{this.getLeastUpperBound(this.myComponentTypes)};
        if (psiTypeArray != null) return psiTypeArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType.getParameters must not return null");
    }

    public String getInternalCanonicalText() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; i < this.myComponentTypes.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(GrTupleType.getInternalCanonicalText(this.myComponentTypes[i]));
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean isValid() {
        for (PsiType initializer : this.myComponentTypes) {
            if (initializer == null || initializer.isValid()) continue;
            return false;
        }
        return true;
    }

    public PsiClassType setLanguageLevel(LanguageLevel languageLevel) {
        return new GrTupleType(this.myComponentTypes, this.myFacade, this.myScope, languageLevel);
    }

    public boolean equals(Object obj) {
        if (obj instanceof GrTupleType) {
            PsiType[] otherComponents = ((GrTupleType)((Object)obj)).myComponentTypes;
            for (int i = 0; i < Math.min(this.myComponentTypes.length, otherComponents.length); ++i) {
                if (Comparing.equal((Object)this.myComponentTypes[i], (Object)otherComponents[i])) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    public boolean isAssignableFrom(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GrTupleType.isAssignableFrom must not be null");
        }
        if (type instanceof GrTupleType) {
            PsiType[] otherComponents = ((GrTupleType)type).myComponentTypes;
            for (int i = 0; i < Math.min(this.myComponentTypes.length, otherComponents.length); ++i) {
                PsiType componentType = this.myComponentTypes[i];
                PsiType otherComponent = otherComponents[i];
                if (!(otherComponent == null ? componentType != null && !componentType.equalsToText("java.lang.Object") : componentType != null && !componentType.isAssignableFrom(otherComponent))) continue;
                return false;
            }
            return true;
        }
        return super.isAssignableFrom(type);
    }

    public PsiType[] getComponentTypes() {
        return this.myComponentTypes;
    }
}

