/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParams;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocMemberReferenceImpl;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;

public class GrDocMethodReferenceImpl
extends GrDocMemberReferenceImpl
implements GrDocMethodReference {
    public GrDocMethodReferenceImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocMethodReferenceImpl.<init> must not be null");
        }
        super(node);
    }

    public String toString() {
        return "GrDocMethodReference";
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitDocMethodReference(this);
    }

    @Override
    @NotNull
    public GrDocMethodParams getParameterList() {
        GrDocMethodParams child = (GrDocMethodParams)this.findChildByClass(GrDocMethodParams.class);
        assert (child != null);
        GrDocMethodParams grDocMethodParams = child;
        if (grDocMethodParams == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocMethodReferenceImpl.getParameterList must not return null");
        }
        return grDocMethodParams;
    }

    @Override
    protected ResolveResult[] multiResolveImpl() {
        GrCodeReferenceElement referenceElement;
        String name = this.getReferenceName();
        GrDocReferenceElement holder = this.getReferenceHolder();
        Object resolved = holder != null ? ((referenceElement = holder.getReferenceElement()) != null ? referenceElement.resolve() : null) : GrDocMethodReferenceImpl.getEnclosingClass(this);
        if (resolved instanceof PsiClass) {
            PsiType[] parameterTypes = this.getParameterList().getParameterTypes();
            PsiClassType thisType = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createType(resolved, PsiSubstitutor.EMPTY);
            MethodResolverProcessor processor = new MethodResolverProcessor(name, this, false, (PsiType)thisType, parameterTypes, PsiType.EMPTY_ARRAY);
            MethodResolverProcessor constructorProcessor = new MethodResolverProcessor(name, this, true, (PsiType)thisType, parameterTypes, PsiType.EMPTY_ARRAY);
            resolved.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)resolved, (PsiElement)this);
            resolved.processDeclarations((PsiScopeProcessor)constructorProcessor, ResolveState.initial(), (PsiElement)resolved, (PsiElement)this);
            return (ResolveResult[])ArrayUtil.mergeArrays((Object[])processor.getCandidates(), (Object[])constructorProcessor.getCandidates(), GroovyResolveResult.class);
        }
        return new ResolveResult[0];
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        if (element instanceof PsiNamedElement && Comparing.equal((String)((PsiNamedElement)element).getName(), (String)this.getReferenceName())) {
            return this.getManager().areElementsEquivalent(element, this.resolve());
        }
        return false;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiElement resolved = this.resolve();
        if (resolved instanceof PsiMethod) {
            String newPropertyName;
            PsiMethod method = (PsiMethod)resolved;
            String oldName = this.getReferenceName();
            if (!method.getName().equals(oldName) && PropertyUtil.isSimplePropertyAccessor((PsiMethod)method) && (newPropertyName = PropertyUtil.getPropertyName((String)newElementName)) != null) {
                return super.handleElementRename(newPropertyName);
            }
        }
        return super.handleElementRename(newElementName);
    }
}

