/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.handlers;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.completion.DefaultInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class AfterNewClassInsertHandler
implements InsertHandler<LookupItem<PsiClassType>> {
    private final PsiClassType myClassType;
    private final PsiElement myPlace;

    public AfterNewClassInsertHandler(PsiClassType classType, PsiElement place) {
        this.myClassType = classType;
        this.myPlace = place;
    }

    public void handleInsert(InsertionContext context, LookupItem<PsiClassType> item) {
        PsiResolveHelper resolveHelper;
        PsiClass psiClass = com.intellij.psi.util.PsiUtil.resolveClassInType((PsiType)this.myClassType);
        if (psiClass == null || !psiClass.isValid()) {
            return;
        }
        Object[] constructors = psiClass.getConstructors();
        boolean hasParams = ContainerUtil.or((Object[])constructors, (Condition)new Condition<PsiMethod>(resolveHelper = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getResolveHelper()){
            final /* synthetic */ PsiResolveHelper val$resolveHelper;
            {
                this.val$resolveHelper = psiResolveHelper;
            }

            public boolean value(PsiMethod psiMethod) {
                if (!this.val$resolveHelper.isAccessible((PsiMember)psiMethod, AfterNewClassInsertHandler.this.myPlace, null)) {
                    return false;
                }
                return psiMethod.getParameterList().getParametersCount() > 0;
            }
        });
        if (hasParams) {
            ParenthesesInsertHandler.WITH_PARAMETERS.handleInsert(context, item);
        } else {
            ParenthesesInsertHandler.NO_PARAMETERS.handleInsert(context, item);
        }
        AfterNewClassInsertHandler.addImportForItem(context.getFile(), context.getStartOffset(), item);
        if (hasParams) {
            AutoPopupController.getInstance((Project)constructors[0].getProject()).autoPopupParameterInfo(context.getEditor(), null);
        }
    }

    public static void addImportForItem(PsiFile file, int startOffset, LookupItem item) throws IncorrectOperationException {
        PsiClass refClass;
        PsiType type;
        PsiDocumentManager.getInstance((Project)file.getProject()).commitAllDocuments();
        Object o = item.getObject();
        if (o instanceof PsiClass) {
            PsiClass aClass = (PsiClass)o;
            if (aClass.getQualifiedName() == null) {
                return;
            }
            String lookupString = item.getLookupString();
            int length = lookupString.length();
            int i = lookupString.indexOf(60);
            if (i >= 0) {
                length = i;
            }
            int newOffset = AfterNewClassInsertHandler.addImportForClass(file, startOffset, startOffset + length, aClass);
            AfterNewClassInsertHandler.shortenReference(file, newOffset);
        } else if (o instanceof PsiType && (type = ((PsiType)o).getDeepComponentType()) instanceof PsiClassType && (refClass = ((PsiClassType)type).resolve()) != null) {
            int length = refClass.getName().length();
            AfterNewClassInsertHandler.addImportForClass(file, startOffset, startOffset + length, refClass);
        }
    }

    private static int addImportForClass(PsiFile file, int startOffset, int endOffset, PsiClass aClass) throws IncorrectOperationException {
        PsiElement resolved;
        PsiManager manager = file.getManager();
        Document document = FileDocumentManager.getInstance().getDocument(file.getViewProvider().getVirtualFile());
        int newStartOffset = startOffset;
        PsiReference reference = file.findReferenceAt(startOffset);
        if (reference != null && (resolved = reference.resolve()) instanceof PsiClass && (((PsiClass)resolved).getQualifiedName() == null || manager.areElementsEquivalent((PsiElement)aClass, resolved))) {
            return newStartOffset;
        }
        String name = aClass.getName();
        document.replaceString(startOffset, endOffset, (CharSequence)name);
        RangeMarker toDelete = DefaultInsertHandler.insertSpace((int)endOffset, (Document)document);
        PsiDocumentManager.getInstance((Project)manager.getProject()).commitAllDocuments();
        PsiReference ref = file.findReferenceAt(startOffset);
        if (ref instanceof GrCodeReferenceElement && aClass.isValid()) {
            PsiElement newElement = ref.bindToElement((PsiElement)aClass);
            RangeMarker marker = document.createRangeMarker(newElement.getTextRange());
            CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)newElement);
            newStartOffset = marker.getStartOffset();
        }
        if (toDelete.isValid()) {
            document.deleteString(toDelete.getStartOffset(), toDelete.getEndOffset());
        }
        return newStartOffset;
    }

    private static void shortenReference(PsiFile file, int offset) throws IncorrectOperationException {
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file.getProject());
        Document document = manager.getDocument(file);
        manager.commitDocument(document);
        PsiReference ref = file.findReferenceAt(offset);
        if (ref instanceof GrCodeReferenceElement) {
            PsiUtil.shortenReference((GrCodeReferenceElement)ref);
            PsiUtil.shortenReferences((GroovyPsiElement)ref);
        }
    }
}

