/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.ErrorUtil;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class RemoveUnnecessaryBracesInGStringIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        MyPredicate myPredicate = new MyPredicate();
        if (myPredicate == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/intentions/conversions/RemoveUnnecessaryBracesInGStringIntention.getElementPredicate must not return null");
        }
        return myPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/intentions/conversions/RemoveUnnecessaryBracesInGStringIntention.processIntention must not be null");
        }
        GrStringUtil.removeUnnecessaryBracesInGString((GrString)element);
    }

    public static class MyPredicate
    implements PsiElementPredicate {
        @Override
        public boolean satisfiedBy(PsiElement element) {
            return MyPredicate.isIntentionAvailable(element);
        }

        public static boolean isIntentionAvailable(PsiElement element) {
            if (!(element instanceof GrString)) {
                return false;
            }
            if (ErrorUtil.containsError(element)) {
                return false;
            }
            for (PsiElement child : element.getChildren()) {
                if (!GrStringUtil.checkGStringInjectionForUnnecessaryBraces(child)) continue;
                return true;
            }
            return false;
        }
    }
}

