/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.highlighter;

import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;

public class GroovyBraceMatcher
implements PairedBraceMatcher {
    private static final BracePair[] PAIRS = new BracePair[]{new BracePair(GroovyTokenTypes.mLPAREN, GroovyTokenTypes.mRPAREN, false), new BracePair(GroovyTokenTypes.mLBRACK, GroovyTokenTypes.mRBRACK, false), new BracePair(GroovyTokenTypes.mLCURLY, GroovyTokenTypes.mRCURLY, true), new BracePair(GroovyDocTokenTypes.mGDOC_INLINE_TAG_START, GroovyDocTokenTypes.mGDOC_INLINE_TAG_END, true), new BracePair(GroovyDocTokenTypes.mGDOC_TAG_VALUE_LPAREN, GroovyDocTokenTypes.mGDOC_TAG_VALUE_RPAREN, false), new BracePair(GroovyTokenTypes.mGSTRING_BEGIN, GroovyTokenTypes.mGSTRING_END, false), new BracePair(GroovyTokenTypes.mREGEX_BEGIN, GroovyTokenTypes.mREGEX_END, false)};

    public BracePair[] getPairs() {
        return PAIRS;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType ibraceType, @Nullable IElementType tokenType) {
        if (ibraceType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/highlighter/GroovyBraceMatcher.isPairedBracesAllowedBeforeType must not be null");
        }
        return tokenType == null || GroovyTokenTypes.mWS == tokenType || TokenSets.COMMENT_SET.contains(tokenType) || tokenType == GroovyTokenTypes.mSEMI || tokenType == GroovyTokenTypes.mCOMMA || tokenType == GroovyTokenTypes.mRPAREN || tokenType == GroovyTokenTypes.mRBRACK || tokenType == GroovyTokenTypes.mRCURLY || tokenType == GroovyTokenTypes.mGSTRING_BEGIN;
    }

    public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
        return openingBraceOffset;
    }
}

