/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.refactoring.psi.SearchUtils;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public class AntTasksProvider {
    @NonNls
    public static final String ANT_TASK_CLASS = "org.apache.tools.ant.Task";
    private final Project myProject;
    private final CachedValue<Set<String>> myCachedValue;

    public static AntTasksProvider getInstance(Project project) {
        return (AntTasksProvider)ServiceManager.getService((Project)project, AntTasksProvider.class);
    }

    public AntTasksProvider(Project project) {
        this.myProject = project;
        CachedValuesManager manager = CachedValuesManager.getManager((Project)this.myProject);
        this.myCachedValue = manager.createCachedValue((CachedValueProvider)new CachedValueProvider<Set<String>>(){

            public CachedValueProvider.Result<Set<String>> compute() {
                HashSet set = AntTasksProvider.findAntTasks(AntTasksProvider.this.myProject);
                return CachedValueProvider.Result.create((Object)set, (Object[])new Object[]{ProjectRootManager.getInstance((Project)AntTasksProvider.this.myProject), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        }, false);
    }

    public Set<String> getAntTasks() {
        return (Set)this.myCachedValue.getValue();
    }

    private static HashSet<String> findAntTasks(Project project) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass taskClass = facade.findClass(ANT_TASK_CLASS, GlobalSearchScope.allScope((Project)project));
        if (taskClass != null) {
            Iterable inheritors = SearchUtils.findClassInheritors((PsiClass)taskClass, (boolean)true);
            HashSet classNames = new HashSet();
            for (PsiClass inheritor : inheritors) {
                if (inheritor.hasModifierProperty("abstract") || inheritor.hasModifierProperty("private")) continue;
                classNames.add((Object)inheritor.getName());
            }
            return classNames;
        }
        return new HashSet(0);
    }
}

