/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.processors;

import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.formatter.GroovyBlock;
import org.jetbrains.plugins.groovy.formatter.processors.SpacingUtil;
import org.jetbrains.plugins.groovy.lang.editor.actions.GroovyEditorActionUtil;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocFieldReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParameter;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParams;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrFinallyClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovySpacingProcessor
extends GroovyPsiElementVisitor {
    private static final ThreadLocal<GroovySpacingProcessor> mySharedProcessorAllocator = new ThreadLocal();
    protected MyGroovySpacingVisitor myGroovyElementVisitor;
    protected static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.formatter.processors.GroovySpacingProcessor");

    private GroovySpacingProcessor(MyGroovySpacingVisitor visitor) {
        super(visitor);
        this.myGroovyElementVisitor = visitor;
    }

    public static Spacing getSpacing(GroovyBlock child1, GroovyBlock child2, CodeStyleSettings settings) {
        return GroovySpacingProcessor.getSpacing(child2.getNode(), settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Spacing getSpacing(ASTNode node, CodeStyleSettings settings) {
        GroovySpacingProcessor spacingProcessor = mySharedProcessorAllocator.get();
        try {
            if (spacingProcessor == null) {
                spacingProcessor = new GroovySpacingProcessor(new MyGroovySpacingVisitor(node, settings));
                mySharedProcessorAllocator.set(spacingProcessor);
            } else {
                spacingProcessor.setVisitor(new MyGroovySpacingVisitor(node, settings));
            }
            spacingProcessor.doInit();
            Spacing spacing = spacingProcessor.getResult();
            return spacing;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            Spacing spacing = null;
            return spacing;
        }
        finally {
            spacingProcessor.clear();
        }
    }

    private void doInit() {
        this.myGroovyElementVisitor.doInit();
    }

    private void clear() {
        if (this.myGroovyElementVisitor != null) {
            this.myGroovyElementVisitor.clear();
        }
    }

    private Spacing getResult() {
        return this.myGroovyElementVisitor.getResult();
    }

    public void setVisitor(MyGroovySpacingVisitor visitor) {
        this.myGroovyElementVisitor = visitor;
    }

    private static class MyGroovySpacingVisitor
    extends GroovyElementVisitor {
        private PsiElement myParent;
        private final CodeStyleSettings mySettings;
        private Spacing myResult;
        private ASTNode myChild1;
        private ASTNode myChild2;

        public MyGroovySpacingVisitor(ASTNode node, CodeStyleSettings settings) {
            this.mySettings = settings;
            this.init(node);
        }

        private void init(ASTNode child) {
            ASTNode treePrev;
            if (child == null) {
                return;
            }
            for (treePrev = child.getTreePrev(); treePrev != null && SpacingUtil.isWhiteSpace(treePrev); treePrev = treePrev.getTreePrev()) {
            }
            if (treePrev == null) {
                this.init(child.getTreeParent());
            } else {
                this.myChild2 = child;
                this.myChild1 = treePrev;
                CompositeElement parent = (CompositeElement)treePrev.getTreeParent();
                this.myParent = SourceTreeToPsiMap.treeElementToPsi((ASTNode)parent);
            }
        }

        private void doInit() {
            ASTNode prev;
            if (this.myChild1 == null || this.myChild2 == null) {
                return;
            }
            PsiElement psi1 = this.myChild1.getPsi();
            PsiElement psi2 = this.myChild2.getPsi();
            if (psi1 == null || psi2 == null) {
                return;
            }
            if (psi1.getLanguage() != GroovyFileType.GROOVY_LANGUAGE || psi2.getLanguage() != GroovyFileType.GROOVY_LANGUAGE) {
                return;
            }
            if (this.myChild2 != null && this.mySettings.KEEP_FIRST_COLUMN_COMMENT && SpacingUtil.COMMENT_BIT_SET.contains(this.myChild2.getElementType())) {
                if (this.myChild1.getElementType() != GroovyElementTypes.IMPORT_STATEMENT) {
                    this.myResult = Spacing.createKeepingFirstColumnSpacing((int)0, (int)Integer.MAX_VALUE, (boolean)true, (int)1);
                }
                return;
            }
            if (this.myChild1 != null && this.myChild2 != null && this.myChild1.getElementType() == GroovyElementTypes.mNLS && (prev = SpacingUtil.getPrevElementType(this.myChild1)) != null && prev.getElementType() == GroovyTokenTypes.mSL_COMMENT) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                return;
            }
            if (this.myParent instanceof GroovyPsiElement) {
                ((GroovyPsiElement)this.myParent).accept(this);
            }
        }

        @Override
        public void visitAnnotation(GrAnnotation annotation) {
            if (this.myChild2.getElementType() == GroovyElementTypes.ANNOTATION_ARGUMENTS) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        }

        @Override
        public void visitArgumentList(GrArgumentList list) {
            if (this.myChild1.getElementType() == GroovyTokenTypes.mLBRACK || this.myChild2.getElementType() == GroovyTokenTypes.mRBRACK) {
                this.createSpaceInCode(this.mySettings.SPACE_WITHIN_BRACKETS);
            }
        }

        @Override
        public void visitMethodCallExpression(GrMethodCallExpression methodCallExpression) {
            if (this.myChild2.getElementType() == GroovyElementTypes.ARGUMENTS) {
                this.createSpaceInCode(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
            }
        }

        @Override
        public void visitClosure(GrClosableBlock closure) {
            GrStatement[] statements;
            if (this.myChild1.getElementType() == GroovyTokenTypes.mLCURLY && this.myChild2.getElementType() != GroovyElementTypes.PARAMETERS_LIST && this.myChild2.getElementType() != GroovyElementTypes.mCLOSABLE_BLOCK_OP || this.myChild2.getElementType() == GroovyElementTypes.mRCURLY) {
                this.myResult = Spacing.createDependentLFSpacing((int)0, (int)Integer.MAX_VALUE, (TextRange)closure.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else if (this.myChild1.getElementType() == GroovyElementTypes.mCLOSABLE_BLOCK_OP && (statements = closure.getStatements()).length > 0) {
                TextRange range = new TextRange(statements[0].getTextRange().getStartOffset(), statements[statements.length - 1].getTextRange().getEndOffset());
                this.myResult = Spacing.createDependentLFSpacing((int)1, (int)Integer.MAX_VALUE, (TextRange)range, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        }

        @Override
        public void visitOpenBlock(GrOpenBlock block) {
            if (this.myChild1.getElementType() == GroovyTokenTypes.mLCURLY && this.myChild2.getElementType() == GroovyElementTypes.mRCURLY && block.getParent() instanceof GrBlockStatement) {
                this.myResult = Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else if (this.myChild1.getElementType() == GroovyTokenTypes.mLCURLY && !GroovyEditorActionUtil.isMultilineStringElement(this.myChild2) || this.myChild2.getElementType() == GroovyElementTypes.mRCURLY && !GroovyEditorActionUtil.isMultilineStringElement(this.myChild1)) {
                this.myResult = Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)block.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        }

        @Override
        public void visitNewExpression(GrNewExpression newExpression) {
            if (this.myChild1.getElementType() == GroovyTokenTypes.kNEW) {
                this.createSpaceInCode(true);
            } else if (this.myChild2.getElementType() == GroovyElementTypes.ARGUMENTS) {
                this.createSpaceInCode(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
            }
        }

        @Override
        public void visitTypeDefinition(GrTypeDefinition typeDefinition) {
            if (this.myChild2.getElementType() == GroovyElementTypes.CLASS_BODY) {
                PsiIdentifier nameIdentifier = typeDefinition.getNameIdentifier();
                int dependanceStart = nameIdentifier == null ? this.myParent.getTextRange().getStartOffset() : nameIdentifier.getTextRange().getStartOffset();
                this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_CLASS_LBRACE, this.mySettings.CLASS_BRACE_STYLE, new TextRange(dependanceStart, this.myChild1.getTextRange().getEndOffset()), false);
            }
        }

        @Override
        public void visitTypeDefinitionBody(GrTypeDefinitionBody typeDefinitionBody) {
            if (this.myChild1.getElementType() == GroovyTokenTypes.mLCURLY && this.myChild2.getElementType() == GroovyElementTypes.mRCURLY) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            } else if (this.myChild1.getElementType() == GroovyTokenTypes.mLCURLY) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)(this.mySettings.BLANK_LINES_AFTER_CLASS_HEADER + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            } else if (this.myChild2.getElementType() == GroovyElementTypes.mRCURLY) {
                this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            }
        }

        @Override
        public void visitMethod(GrMethod method) {
            if (this.myChild2.getElementType() == GroovyTokenTypes.mLPAREN) {
                this.createSpaceInCode(this.mySettings.SPACE_BEFORE_METHOD_PARENTHESES);
            } else if (this.myChild2.getElementType() == GroovyTokenTypes.mRPAREN && this.myChild2.getElementType() == GroovyElementTypes.THROW_CLAUSE) {
                this.createSpaceInCode(true);
            } else if (this.myChild2.getElementType() == GroovyElementTypes.OPEN_BLOCK) {
                PsiIdentifier methodName = method.getNameIdentifier();
                int dependancyStart = methodName == null ? this.myParent.getTextRange().getStartOffset() : methodName.getTextRange().getStartOffset();
                this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_METHOD_LBRACE, this.mySettings.METHOD_BRACE_STYLE, new TextRange(dependancyStart, this.myChild1.getTextRange().getEndOffset()), this.mySettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE);
            } else if (this.myChild1.getElementType() == GroovyElementTypes.MODIFIERS) {
                this.processModifierList(this.myChild1);
            } else if (GroovyTokenTypes.COMMENT_SET.contains(this.myChild1.getElementType()) && (this.myChild2.getElementType() == GroovyElementTypes.MODIFIERS || this.myChild2.getElementType() == GroovyElementTypes.REFERENCE_ELEMENT)) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
            }
        }

        @Override
        public void visitDocMethodReference(GrDocMethodReference reference) {
            this.visitDocMember();
        }

        @Override
        public void visitDocFieldReference(GrDocFieldReference reference) {
            this.visitDocMember();
        }

        private void visitDocMember() {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
        }

        @Override
        public void visitDocMethodParameterList(GrDocMethodParams params) {
            if (this.myChild1.getElementType() == GroovyDocTokenTypes.mGDOC_TAG_VALUE_LPAREN || this.myChild2.getElementType() == GroovyElementTypes.mGDOC_TAG_VALUE_RPAREN) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
                return;
            }
            if (this.myChild2.getElementType() == GroovyDocTokenTypes.mGDOC_TAG_VALUE_COMMA) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
                return;
            }
            this.createSpaceInCode(true);
        }

        @Override
        public void visitDocMethodParameter(GrDocMethodParameter parameter) {
            if (this.myChild1.getTreePrev() == null) {
                this.createSpaceInCode(true);
            }
        }

        @Override
        public void visitWhileStatement(GrWhileStatement statement) {
            if (this.myChild2.getElementType() == GroovyTokenTypes.mLPAREN) {
                this.createSpaceInCode(this.mySettings.SPACE_BEFORE_WHILE_PARENTHESES);
            } else if (this.myChild1.getElementType() == GroovyTokenTypes.mLPAREN || this.myChild2.getElementType() == GroovyTokenTypes.mRPAREN) {
                this.createSpaceInCode(this.mySettings.SPACE_WITHIN_WHILE_PARENTHESES);
            } else if (this.myChild2.getPsi() instanceof GrBlockStatement) {
                this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_WHILE_LBRACE, this.mySettings.BRACE_STYLE, new TextRange(this.myParent.getTextRange().getStartOffset(), this.myChild1.getTextRange().getEndOffset()), this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
            } else {
                this.createSpacingBeforeElementInsideControlStatement();
            }
        }

        @Override
        public void visitCatchClause(GrCatchClause catchClause) {
            if (this.myChild2.getElementType() == GroovyElementTypes.OPEN_BLOCK) {
                this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_TRY_LBRACE, this.mySettings.BRACE_STYLE, null, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
            }
        }

        @Override
        public void visitFinallyClause(GrFinallyClause catchClause) {
            if (this.myChild2.getElementType() == GroovyElementTypes.OPEN_BLOCK) {
                this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_TRY_LBRACE, this.mySettings.BRACE_STYLE, null, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
            }
        }

        @Override
        public void visitTryStatement(GrTryCatchStatement tryCatchStatement) {
            if (this.myChild2.getElementType() == GroovyElementTypes.FINALLY_CLAUSE) {
                this.processOnNewLineCondition(this.mySettings.FINALLY_ON_NEW_LINE);
            } else if (this.myChild2.getElementType() == GroovyElementTypes.OPEN_BLOCK) {
                this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_TRY_LBRACE, this.mySettings.BRACE_STYLE, null, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
            } else if (this.myChild2.getElementType() == GroovyElementTypes.CATCH_CLAUSE) {
                this.processOnNewLineCondition(this.mySettings.CATCH_ON_NEW_LINE);
            }
        }

        @Override
        public void visitSwitchStatement(GrSwitchStatement switchStatement) {
            if (this.myChild1.getElementType() == GroovyTokenTypes.kSWITCH && this.myChild2.getElementType() == GroovyTokenTypes.mLPAREN) {
                this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SWITCH_PARENTHESES);
            } else if (this.myChild1.getElementType() == GroovyTokenTypes.mLPAREN || this.myChild2.getElementType() == GroovyTokenTypes.mRPAREN) {
                this.createSpaceInCode(this.mySettings.SPACE_WITHIN_SWITCH_PARENTHESES);
            } else if (this.myChild2.getElementType() == GroovyTokenTypes.mLCURLY) {
                this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_SWITCH_LBRACE, this.mySettings.BRACE_STYLE, null, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
            }
        }

        @Override
        public void visitSynchronizedStatement(GrSynchronizedStatement synchronizedStatement) {
            if (this.myChild1.getElementType() == GroovyTokenTypes.kSYNCHRONIZED || this.myChild2.getElementType() == GroovyTokenTypes.mLPAREN) {
                this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SYNCHRONIZED_PARENTHESES);
            } else if (this.myChild1.getElementType() == GroovyTokenTypes.mLPAREN || this.myChild2.getElementType() == GroovyTokenTypes.mRPAREN) {
                this.createSpaceInCode(this.mySettings.SPACE_WITHIN_SYNCHRONIZED_PARENTHESES);
            } else if (this.myChild2.getElementType() == GroovyElementTypes.OPEN_BLOCK) {
                this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_SYNCHRONIZED_LBRACE, this.mySettings.BRACE_STYLE, null, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
            }
        }

        @Override
        public void visitDocComment(GrDocComment comment) {
            IElementType type;
            if (this.myChild1.getElementType() == GroovyElementTypes.GDOC_TAG && this.myChild2.getElementType() == GroovyElementTypes.GDOC_TAG && this.mySettings.JD_LEADING_ASTERISKS_ARE_ENABLED && (type = this.myChild1.getLastChildNode().getElementType()) == GroovyElementTypes.mGDOC_ASTERISKS) {
                this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        }

        @Override
        public void visitDocTag(GrDocTag docTag) {
            if (this.myChild1.getElementType() == GroovyElementTypes.mGDOC_INLINE_TAG_START || this.myChild2.getElementType() == GroovyElementTypes.mGDOC_INLINE_TAG_END) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        }

        @Override
        public void visitIfStatement(GrIfStatement ifStatement) {
            if (this.myChild2.getElementType() == GroovyTokenTypes.kELSE) {
                if (this.myChild1.getElementType() != GroovyElementTypes.OPEN_BLOCK && this.myChild1.getElementType() != GroovyElementTypes.BLOCK_STATEMENT) {
                    this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                } else if (this.mySettings.ELSE_ON_NEW_LINE) {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                } else {
                    this.createSpaceProperty(true, false, 0);
                }
            } else if (this.myChild1.getElementType() == GroovyTokenTypes.kELSE) {
                if (this.myChild2.getElementType() == GroovyElementTypes.IF_STATEMENT) {
                    if (this.mySettings.SPECIAL_ELSE_IF_TREATMENT) {
                        this.createSpaceProperty(true, false, 0);
                    } else {
                        this.myResult = Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                    }
                } else if (this.myChild2.getElementType() == GroovyElementTypes.BLOCK_STATEMENT || this.myChild2.getElementType() == GroovyElementTypes.OPEN_BLOCK) {
                    this.myResult = this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_ELSE_LBRACE, this.mySettings.BRACE_STYLE, null, this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
                } else {
                    this.createSpacingBeforeElementInsideControlStatement();
                }
            } else if (this.myChild2.getElementType() == GroovyElementTypes.BLOCK_STATEMENT || this.myChild2.getElementType() == GroovyElementTypes.OPEN_BLOCK) {
                boolean space = this.myChild2.getPsi() == ((GrIfStatement)this.myParent).getElseBranch() ? this.mySettings.SPACE_BEFORE_ELSE_LBRACE : this.mySettings.SPACE_BEFORE_IF_LBRACE;
                this.myResult = this.getSpaceBeforeLBrace(space, this.mySettings.BRACE_STYLE, new TextRange(this.myParent.getTextRange().getStartOffset(), this.myChild1.getTextRange().getEndOffset()), this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE);
            } else if (this.myChild2.getElementType() == GroovyTokenTypes.mLPAREN) {
                this.createSpaceInCode(this.mySettings.SPACE_BEFORE_IF_PARENTHESES);
            } else if (this.myChild1.getElementType() == GroovyTokenTypes.mLPAREN) {
                this.createSpaceInCode(this.mySettings.SPACE_WITHIN_IF_PARENTHESES);
            } else if (this.myChild2.getElementType() == GroovyTokenTypes.mRPAREN) {
                this.createSpaceInCode(this.mySettings.SPACE_WITHIN_IF_PARENTHESES);
            } else if (((GrIfStatement)this.myParent).getThenBranch() == this.myChild2.getPsi()) {
                this.createSpacingBeforeElementInsideControlStatement();
            }
        }

        @Override
        public void visitForStatement(GrForStatement forStatement) {
            if (this.myChild2.getElementType() == GroovyTokenTypes.mLPAREN) {
                this.createSpaceInCode(this.mySettings.SPACE_BEFORE_FOR_PARENTHESES);
            } else if (this.myChild1.getElementType() == GroovyTokenTypes.mLPAREN) {
                ASTNode rparenth = MyGroovySpacingVisitor.findFrom(this.myChild2, GroovyTokenTypes.mRPAREN, true);
                if (rparenth == null) {
                    this.createSpaceInCode(this.mySettings.SPACE_WITHIN_FOR_PARENTHESES);
                } else {
                    this.createParenSpace(this.mySettings.FOR_STATEMENT_LPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_FOR_PARENTHESES, new TextRange(this.myChild1.getTextRange().getStartOffset(), rparenth.getTextRange().getEndOffset()));
                }
            } else if (this.myChild2.getElementType() == GroovyTokenTypes.mRPAREN) {
                ASTNode lparenth = MyGroovySpacingVisitor.findFrom(this.myChild2, GroovyTokenTypes.mLPAREN, false);
                if (lparenth == null) {
                    this.createSpaceInCode(this.mySettings.SPACE_WITHIN_FOR_PARENTHESES);
                } else {
                    this.createParenSpace(this.mySettings.FOR_STATEMENT_RPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_FOR_PARENTHESES, new TextRange(lparenth.getTextRange().getStartOffset(), this.myChild2.getTextRange().getEndOffset()));
                }
            } else if (this.myChild2.getElementType() == GroovyElementTypes.BLOCK_STATEMENT || this.myChild2.getElementType() == GroovyElementTypes.OPEN_BLOCK) {
                this.myResult = this.myChild2.getElementType() == GroovyElementTypes.BLOCK_STATEMENT ? this.getSpaceBeforeLBrace(this.mySettings.SPACE_BEFORE_FOR_LBRACE, this.mySettings.BRACE_STYLE, new TextRange(this.myParent.getTextRange().getStartOffset(), this.myChild1.getTextRange().getEndOffset()), this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE) : (this.mySettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE ? Spacing.createDependentLFSpacing((int)1, (int)1, (TextRange)this.myParent.getTextRange(), (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE));
            }
        }

        private void createParenSpace(boolean onNewLine, boolean space) {
            this.createParenSpace(onNewLine, space, this.myParent.getTextRange());
        }

        private void createParenSpace(boolean onNewLine, boolean space, TextRange dependance) {
            if (onNewLine) {
                int spaces = space ? 1 : 0;
                this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)dependance, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else {
                this.createSpaceInCode(space);
            }
        }

        private static ASTNode findFrom(ASTNode current, IElementType expected, boolean forward) {
            while (current != null) {
                if (current.getElementType() == expected) {
                    return current;
                }
                current = forward ? current.getTreeNext() : current.getTreePrev();
            }
            return null;
        }

        private void processOnNewLineCondition(boolean onNewLine) {
            if (onNewLine) {
                this.myResult = !this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE ? Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else {
                this.createSpaceProperty(true, this.mySettings.KEEP_LINE_BREAKS, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        }

        private void createSpacingBeforeElementInsideControlStatement() {
            if (this.mySettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE && this.myChild1.getElementType() != GroovyTokenTypes.mSL_COMMENT) {
                this.createSpaceProperty(true, this.mySettings.KEEP_LINE_BREAKS, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else {
                this.myResult = Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        }

        private void processModifierList(ASTNode modifierList) {
            if (modifierList.getLastChildNode().getElementType() == GroovyElementTypes.ANNOTATION && this.mySettings.METHOD_ANNOTATION_WRAP == 2) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else if (this.mySettings.MODIFIER_LIST_WRAP) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else {
                this.createSpaceProperty(true, false, 0);
            }
        }

        protected void clear() {
            this.myResult = null;
            this.myChild1 = null;
            this.myChild2 = null;
            this.myParent = null;
        }

        protected Spacing getResult() {
            Spacing result = this.myResult;
            this.clear();
            return result;
        }

        private void createSpaceInCode(boolean space) {
            this.createSpaceProperty(space, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }

        private void createSpaceProperty(boolean space, int keepBlankLines) {
            this.createSpaceProperty(space, this.mySettings.KEEP_LINE_BREAKS, keepBlankLines);
        }

        private void createSpaceProperty(boolean space, boolean keepLineBreaks, int keepBlankLines) {
            ASTNode prev = SpacingUtil.getPrevElementType(this.myChild2);
            this.myResult = prev != null && prev.getElementType() == GroovyTokenTypes.mSL_COMMENT ? Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createSpacing((int)(space ? 1 : 0), (int)(space ? 1 : 0), (int)0, (boolean)keepLineBreaks, (int)keepBlankLines);
        }

        private Spacing getSpaceBeforeLBrace(boolean spaceBeforeLbrace, int braceStyle, TextRange dependantRange, boolean keepOneLine) {
            if (dependantRange != null && braceStyle == 5) {
                int space = spaceBeforeLbrace ? 1 : 0;
                return this.createNonLFSpace(space, dependantRange, false);
            }
            if (braceStyle == 1 || braceStyle == 5) {
                int space = spaceBeforeLbrace ? 1 : 0;
                return this.createNonLFSpace(space, null, false);
            }
            if (keepOneLine) {
                int space = spaceBeforeLbrace ? 1 : 0;
                return Spacing.createDependentLFSpacing((int)space, (int)space, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }

        private Spacing createNonLFSpace(int spaces, TextRange dependantRange, boolean keepLineBreaks) {
            ASTNode prev = SpacingUtil.getPrevElementType(this.myChild2);
            if (prev != null && prev.getElementType() == GroovyTokenTypes.mSL_COMMENT) {
                return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)1, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
            if (dependantRange != null) {
                return Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)dependantRange, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }
}

