/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.search.AnnotatedElementsSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.ArrayList;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.stubs.GroovyCacheUtil;

public class AnnotatedMembersSearcher
implements QueryExecutor<PsiMember, AnnotatedElementsSearch.Parameters> {
    public boolean execute(AnnotatedElementsSearch.Parameters p, Processor<PsiMember> consumer) {
        PsiMember[] candidates;
        PsiClass annClass = p.getAnnotationClass();
        assert (annClass.isAnnotationType()) : "Annotation type should be passed to annotated members search";
        String annotationFQN = annClass.getQualifiedName();
        assert (annotationFQN != null);
        SearchScope scope = p.getScope();
        if (scope instanceof GlobalSearchScope) {
            candidates = GroovyCacheUtil.getAnnotatedMemberCandidates(annClass, (GlobalSearchScope)scope);
        } else {
            PsiElement[] elements = ((LocalSearchScope)scope).getScope();
            final ArrayList collector = new ArrayList();
            for (PsiElement element : elements) {
                if (!(element instanceof GroovyPsiElement)) continue;
                ((GroovyPsiElement)element).accept(new GroovyRecursiveElementVisitor(){

                    @Override
                    public void visitMethod(GrMethod method) {
                        collector.add(method);
                    }

                    @Override
                    public void visitField(GrField field) {
                        collector.add(field);
                    }
                });
            }
            candidates = collector.toArray(new PsiMember[collector.size()]);
        }
        for (PsiMember candidate : candidates) {
            PsiModifierList list;
            if (!AnnotatedElementsSearcher.isInstanceof((PsiElement)candidate, (Class[])p.getTypes()) || (list = candidate.getModifierList()) == null) continue;
            for (PsiAnnotation annotation : list.getAnnotations()) {
                PsiClass clazz;
                if (!annotationFQN.equals(annotation.getQualifiedName()) || (clazz = candidate.getContainingClass()) instanceof GroovyScriptClass || consumer.process((Object)candidate)) continue;
                return false;
            }
        }
        return true;
    }
}

