/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.toplevel;

import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;

public class ClassContextFilter
implements ContextFilter {
    private final ElementPattern<PsiClass> myPattern;

    public ClassContextFilter(ElementPattern<PsiClass> pattern) {
        this.myPattern = pattern;
    }

    @Override
    public boolean isApplicable(PsiElement place, String fqName, ProcessingContext ctx) {
        return this.myPattern.accepts((Object)ClassContextFilter.findPsiClass(place, fqName, ctx), ctx);
    }

    @Nullable
    private static PsiClass findPsiClass(PsiElement place, String fqName, ProcessingContext ctx) {
        String key = ClassContextFilter.getClassKey(fqName);
        Object cached = ctx.get(key);
        if (cached == Boolean.FALSE) {
            return null;
        }
        if (cached instanceof PsiClass) {
            return (PsiClass)cached;
        }
        PsiClass found = JavaPsiFacade.getInstance((Project)place.getProject()).findClass(fqName, place.getResolveScope());
        ctx.put(key, (Object)(found == null ? Boolean.FALSE : found));
        return found;
    }

    public static String getClassKey(String fqName) {
        return "Class: " + fqName;
    }
}

