/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.compiler.CompilerSettingsFactory;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfigurable;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfiguration;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfiguration;

public class GroovyCompilerConfigurable
implements SearchableConfigurable,
CompilerSettingsFactory {
    private JTextField myHeapSize;
    private JPanel myMainPanel;
    private JPanel myExcludesPanel;
    private JCheckBox myUseGroovycStubs;
    private ExcludedEntriesConfigurable myExcludes;
    private final GroovyCompilerConfiguration myConfig;

    public GroovyCompilerConfigurable(Project project) {
        this.$$$setupUI$$$();
        this.myConfig = GroovyCompilerConfiguration.getInstance(project);
        this.myExcludes = this.createExcludedConfigurable(project);
    }

    public ExcludedEntriesConfigurable getExcludes() {
        return this.myExcludes;
    }

    private ExcludedEntriesConfigurable createExcludedConfigurable(Project project) {
        ExcludedEntriesConfiguration configuration = this.myConfig.getExcludeFromStubGeneration();
        final ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, true){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && !index.isIgnored(file);
            }
        };
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (VirtualFile file : ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
                descriptor.addRoot(file);
            }
        }
        return new ExcludedEntriesConfigurable(project, descriptor, configuration);
    }

    public String getId() {
        return "Groovy compiler";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Groovy Compiler";
    }

    public Icon getIcon() {
        return GroovyIcons.GROOVY_ICON_16x16;
    }

    public String getHelpTopic() {
        return "reference.projectsettings.compiler.groovy";
    }

    public JComponent createComponent() {
        this.myExcludesPanel.add(this.myExcludes.createComponent());
        return this.myMainPanel;
    }

    public boolean isModified() {
        return !Comparing.equal((String)this.myConfig.getHeapSize(), (String)this.myHeapSize.getText()) || this.myExcludes.isModified() || this.myConfig.isUseGroovycStubs() != this.myUseGroovycStubs.isSelected();
    }

    public void apply() throws ConfigurationException {
        this.myExcludes.apply();
        this.myConfig.setHeapSize(this.myHeapSize.getText());
        this.myConfig.setUseGroovycStubs(this.myUseGroovycStubs.isSelected());
    }

    public void reset() {
        this.myHeapSize.setText(this.myConfig.getHeapSize());
        this.myUseGroovycStubs.setSelected(this.myConfig.isUseGroovycStubs());
        this.myExcludes.reset();
    }

    public void disposeUIResources() {
        this.myExcludes.disposeUIResources();
    }

    public Configurable create(Project project) {
        return this;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JTextField jTextField;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CompilerBundle").getString("javac.option.max.heap.size"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHeapSize = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myUseGroovycStubs = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use groovyc's native stub generator");
        jCheckBox.setMnemonic('S');
        jCheckBox.setDisplayedMnemonicIndex(21);
        jPanel3.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myExcludesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Exclude from stub generation", 0, 0, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

