/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.refactoring.RenameRefactoring;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;

class RenameFix
extends GroovyFix {
    private final String targetName;

    public RenameFix() {
        this.targetName = null;
    }

    public RenameFix(@NonNls String targetName) {
        this.targetName = targetName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getName() {
        if (this.targetName == null) {
            return "Rename";
        }
        String string = "Rename to " + this.targetName;
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/naming/RenameFix.getName must not return null");
        return string2;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement nameIdentifier = descriptor.getPsiElement();
        PsiElement elementToRename = nameIdentifier.getParent();
        if (this.targetName == null) {
            RefactoringActionHandlerFactory factory = RefactoringActionHandlerFactory.getInstance();
            RefactoringActionHandler renameHandler = factory.createRenameHandler();
            DataManager dataManager = DataManager.getInstance();
            DataContext dataContext = dataManager.getDataContext();
            renameHandler.invoke(project, new PsiElement[]{elementToRename}, dataContext);
        } else {
            RefactoringFactory factory = RefactoringFactory.getInstance((Project)project);
            RenameRefactoring renameRefactoring = factory.createRename(elementToRename, this.targetName);
            renameRefactoring.run();
        }
    }
}

