/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.exception;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;

public class GroovyThrowFromFinallyBlockInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Error handling" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/exception/GroovyThrowFromFinallyBlockInspection.getGroupDisplayName must not return null");
        }
        return "Error handling";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("'throw' inside 'finally' block" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/exception/GroovyThrowFromFinallyBlockInspection.getDisplayName must not return null");
        }
        return "'throw' inside 'finally' block";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "'#ref' inside 'finally' block #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitThrowStatement(GrThrowStatement throwStatement) {
            super.visitThrowStatement(throwStatement);
            if (!ControlFlowUtils.isInFinallyBlock(throwStatement)) {
                return;
            }
            this.registerStatementError(throwStatement, new Object[0]);
        }
    }
}

