/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;

public class GroovyFallthroughInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Control Flow" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyFallthroughInspection.getGroupDisplayName must not return null");
        }
        return "Control Flow";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Fallthrough in switch statement" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyFallthroughInspection.getDisplayName must not return null");
        }
        return "Fallthrough in switch statement";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Fallthough in switch statement #loc";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitSwitchStatement(GrSwitchStatement switchStatement) {
            super.visitSwitchStatement(switchStatement);
            GrCaseSection[] grCaseSections = switchStatement.getCaseSections();
            for (int i = 0; i < grCaseSections.length - 1; ++i) {
                GrStatement lastStatement;
                GrCaseSection caseSection = grCaseSections[i];
                GrStatement[] statements = caseSection.getStatements();
                if (statements.length == 0 || !ControlFlowUtils.statementMayCompleteNormally(lastStatement = statements[statements.length - 1])) continue;
                this.registerError(grCaseSections[i + 1].getFirstChild());
            }
        }
    }
}

