/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyConstantIfStatementInspection
extends BaseInspection {
    @NotNull
    public String getGroupDisplayName() {
        if ("Control Flow" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantIfStatementInspection.getGroupDisplayName must not return null");
        }
        return "Control Flow";
    }

    @NotNull
    public String getDisplayName() {
        if ("Constant if statement" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantIfStatementInspection.getDisplayName must not return null");
        }
        return "Constant if statement";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        if ("#ref statement can be simplified #loc" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantIfStatementInspection.buildErrorString must not return null");
        }
        return "#ref statement can be simplified #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantIfStatementVisitor();
    }

    @Override
    public GroovyFix buildFix(PsiElement location) {
        return new ConstantIfStatementFix();
    }

    private static boolean isFalse(GrExpression expression) {
        String text = expression.getText();
        return "false".equals(text);
    }

    private static boolean isTrue(GrExpression expression) {
        String text = expression.getText();
        return "true".equals(text);
    }

    private static class ConstantIfStatementVisitor
    extends BaseInspectionVisitor {
        private ConstantIfStatementVisitor() {
        }

        @Override
        public void visitIfStatement(GrIfStatement statement) {
            super.visitIfStatement(statement);
            GrCondition condition = statement.getCondition();
            if (!(condition instanceof GrExpression)) {
                return;
            }
            GrStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            GrExpression conditionExpression = (GrExpression)condition;
            if (GroovyConstantIfStatementInspection.isTrue(conditionExpression) || GroovyConstantIfStatementInspection.isFalse(conditionExpression)) {
                this.registerStatementError(statement, new Object[0]);
            }
        }
    }

    private static class ConstantIfStatementFix
    extends GroovyFix {
        private ConstantIfStatementFix() {
        }

        @NotNull
        public String getName() {
            if ("Simplify" == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyConstantIfStatementInspection$ConstantIfStatementFix.getName must not return null");
            }
            return "Simplify";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement ifKeyword = descriptor.getPsiElement();
            GrIfStatement ifStatement = (GrIfStatement)ifKeyword.getParent();
            assert (ifStatement != null);
            GrStatement thenBranch = ifStatement.getThenBranch();
            GrStatement elseBranch = ifStatement.getElseBranch();
            GrExpression condition = (GrExpression)ifStatement.getCondition();
            if (GroovyConstantIfStatementInspection.isFalse(condition)) {
                if (elseBranch != null) {
                    ConstantIfStatementFix.replaceStatement((GrStatement)ifStatement, elseBranch);
                } else {
                    ifStatement.delete();
                }
            } else {
                ConstantIfStatementFix.replaceStatement((GrStatement)ifStatement, thenBranch);
            }
        }
    }
}

