/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui;

import com.intellij.psi.PsiType;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.EventObject;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.MyPair;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicDialog;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;

public class DynamicMethodDialog
extends DynamicDialog {
    private final GrReferenceExpression myReferenceExpression;

    public DynamicMethodDialog(GrReferenceExpression referenceExpression) {
        super(referenceExpression, QuickfixUtil.createSettings(referenceExpression), GroovyExpectedTypesProvider.calculateTypeConstraints((GrExpression)referenceExpression.getParent()));
        this.myReferenceExpression = referenceExpression;
        this.$$$setupUI$$$();
        assert (this.getSettings().isMethod());
        List<MyPair> pairs = this.getSettings().getPairs();
        this.setupParameterTable(pairs);
        this.setupParameterList(pairs);
        this.setTitle(GroovyBundle.message("add.dynamic.method", new Object[0]));
        this.setUpTypeLabel(GroovyBundle.message("dynamic.method.return.type", new Object[0]));
    }

    @Override
    protected void setUpTableNameLabel(String text) {
        super.setUpTableNameLabel(this.getSettings().getPairs().isEmpty() ? GroovyBundle.message("dynamic.properties.table.no.arguments", new Object[0]) : text);
    }

    private void setupParameterTable(final List<MyPair> pairs) {
        final JTable table = this.getParametersTable();
        MySuggestedNameCellEditor suggestedNameCellEditor = new MySuggestedNameCellEditor(QuickfixUtil.getArgumentsNames(pairs));
        table.setDefaultEditor(String.class, (TableCellEditor)((Object)suggestedNameCellEditor));
        suggestedNameCellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                int editingColumn = table.getSelectedColumn();
                if (editingColumn != 0) {
                    return;
                }
                int editingRow = table.getSelectedRow();
                if (editingRow < 0 || editingRow >= pairs.size()) {
                    return;
                }
                String newNameValue = ((MySuggestedNameCellEditor)((Object)e.getSource())).getCellEditorValue();
                MyPair editingPair = (MyPair)pairs.get(editingRow);
                editingPair.setFirst(newNameValue);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
    }

    @Override
    protected boolean isTableVisible() {
        return true;
    }

    private void setupParameterList(List<MyPair> arguments) {
        JTable table = this.getParametersTable();
        ListTableModel dataModel = new ListTableModel(new ColumnInfo[]{new NameColumnInfo(), new TypeColumnInfo()});
        dataModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                DynamicMethodDialog.this.fireDataChanged();
            }
        });
        dataModel.setItems(arguments);
        table.setModel((TableModel)dataModel);
        if (!arguments.isEmpty()) {
            String max0 = arguments.get((int)0).first;
            String max1 = arguments.get((int)0).second;
            for (MyPair argument : arguments) {
                if (argument.first.length() > max0.length()) {
                    max0 = argument.first;
                }
                if (argument.second.length() <= max1.length()) continue;
                max1 = argument.second;
            }
            FontMetrics metrics = table.getFontMetrics(table.getFont());
            TableColumn column0 = table.getColumnModel().getColumn(0);
            column0.setPreferredWidth(metrics.stringWidth(max0 + "  "));
            TableColumn column1 = table.getColumnModel().getColumn(1);
            column1.setPreferredWidth(metrics.stringWidth(max1 + "  "));
        }
    }

    @Override
    protected void updateOkStatus() {
        super.updateOkStatus();
        if (this.getParametersTable().isEditing()) {
            this.setOKActionEnabled(false);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
    }

    private static class MySuggestedNameCellEditor
    extends AbstractTableCellEditor {
        JTextField myNameField;

        public MySuggestedNameCellEditor(String[] names) {
            this.myNameField = names.length == 0 ? new JTextField() : new JTextField(names[0]);
        }

        public String getCellEditorValue() {
            return this.myNameField.getText();
        }

        public boolean isCellEditable(EventObject e) {
            return true;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof String) {
                this.myNameField.setText((String)value);
            }
            return this.myNameField;
        }
    }

    private static class NameColumnInfo
    extends ColumnInfo<MyPair, String> {
        public NameColumnInfo() {
            super(GroovyBundle.message("dynamic.type", new Object[0]));
        }

        public boolean isCellEditable(MyPair myPair) {
            return true;
        }

        public String valueOf(MyPair pair) {
            return pair.first;
        }
    }

    private class TypeColumnInfo
    extends ColumnInfo<MyPair, String> {
        public TypeColumnInfo() {
            super(GroovyBundle.message("dynamic.name", new Object[0]));
        }

        public String valueOf(MyPair pair) {
            return pair.second;
        }

        public boolean isCellEditable(MyPair stringPsiTypeMyPair) {
            return false;
        }

        public void setValue(MyPair pair, String value) {
            PsiType type;
            try {
                type = GroovyPsiElementFactory.getInstance(DynamicMethodDialog.this.getProject()).createTypeElement(value).getType();
            }
            catch (IncorrectOperationException e) {
                return;
            }
            if (type == null) {
                return;
            }
            pair.setSecond(type.getCanonicalText());
        }
    }
}

