/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.lang.editor.template.expressions.ChooseTypeExpression;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrMemberOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;

public abstract class CreateFieldFix
implements IntentionAction {
    private final GrMemberOwner myTargetClass;

    protected GrMemberOwner getTargetClass() {
        return this.myTargetClass;
    }

    protected CreateFieldFix(GrMemberOwner targetClass) {
        this.myTargetClass = targetClass;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFix.isAvailable must not be null");
        }
        return this.myTargetClass.isValid();
    }

    @NotNull
    public String getText() {
        String string = GroovyBundle.message("create.field.from.usage", this.getFieldName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("create.from.usage.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFix.getFamilyName must not return null");
        }
        return string;
    }

    @Nullable
    protected abstract String getFieldName();

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFix.invoke must not be null");
        }
        PsiClassType type = JavaPsiFacade.getInstance((Project)project).getElementFactory().createTypeByFQClassName("Object", GlobalSearchScope.allScope((Project)project));
        String[] modifiers = this.generateModifiers();
        GrVariableDeclaration fieldDecl = GroovyPsiElementFactory.getInstance(project).createFieldDeclaration(modifiers, this.getFieldName(), null, (PsiType)type);
        fieldDecl = this.myTargetClass.addMemberDeclaration(fieldDecl, null);
        GrTypeElement typeElement = fieldDecl.getTypeElementGroovy();
        assert (typeElement != null);
        TypeConstraint[] constraints = this.calculateTypeConstrains();
        ChooseTypeExpression expr = new ChooseTypeExpression(constraints, PsiManager.getInstance((Project)project));
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)fieldDecl);
        builder.replaceElement((PsiElement)typeElement, (Expression)expr);
        fieldDecl = (GrVariableDeclaration)CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)fieldDecl);
        if (fieldDecl == null) {
            return;
        }
        Template template = builder.buildTemplate();
        Editor newEditor = QuickfixUtil.positionCursor(project, this.myTargetClass.getContainingFile(), fieldDecl);
        TextRange range = fieldDecl.getTextRange();
        newEditor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        manager.startTemplate(newEditor, template);
    }

    protected abstract TypeConstraint[] calculateTypeConstrains();

    protected abstract String[] generateModifiers();

    public boolean startInWriteAction() {
        return true;
    }
}

