/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.inspections;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class GroovyImmutableAnnotationInspection
extends BaseInspection {
    public static final String IMMUTABLE = "groovy.lang.Immutable";

    @Override
    protected BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Annotations verifying" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/inspections/GroovyImmutableAnnotationInspection.getGroupDisplayName must not return null");
        }
        return "Annotations verifying";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Check '@Immutable' annotation conventions" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/inspections/GroovyImmutableAnnotationInspection.getDisplayName must not return null");
        }
        return "Check '@Immutable' annotation conventions";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("immutable.class.should.be.final", new Object[0]);
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitAnnotation(GrAnnotation grAnnotation) {
            super.visitAnnotation(grAnnotation);
            PsiElement parent = grAnnotation.getParent().getParent();
            if (parent == null || !(parent instanceof GrTypeDefinition)) {
                return;
            }
            if (GroovyImmutableAnnotationInspection.IMMUTABLE.equals(grAnnotation.getQualifiedName()) && !((GrTypeDefinition)parent).hasModifierProperty("final")) {
                this.registerClassError((GrTypeDefinition)parent, new Object[0]);
            }
        }
    }
}

