/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.conversion;

import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.importWizard.EclipseProjectFinder;

public class EPathUtil {
    static final Logger LOG = Logger.getInstance((String)("#" + EPathUtil.class.getName()));

    private EPathUtil() {
    }

    @NotNull
    public static String getRelativeModuleName(String path) {
        int secondSlIdx = path.indexOf(47, 1);
        String string = secondSlIdx > 1 ? path.substring(1, secondSlIdx) : path.substring(1);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/eclipse/conversion/EPathUtil.getRelativeModuleName must not return null");
        }
        return string;
    }

    @Nullable
    public static String getRelativeToModulePath(String path) {
        int secondSlIdx = path.indexOf(47, 1);
        return secondSlIdx != -1 && secondSlIdx + 1 < path.length() ? path.substring(secondSlIdx + 1) : null;
    }

    public static boolean areUrlsPointTheSame(String ideaUrl, String eclipseUrl) {
        String path = VfsUtil.urlToPath((String)eclipseUrl);
        if (ideaUrl.contains(path)) {
            return true;
        }
        String relativeToModulePath = EPathUtil.getRelativeToModulePath(path);
        int relativeIdx = ideaUrl.indexOf(relativeToModulePath);
        if (relativeIdx != -1) {
            String pathToProjectFile = VfsUtil.urlToPath((String)ideaUrl.substring(0, relativeIdx));
            if (Comparing.strEqual((String)EPathUtil.getRelativeModuleName(path), (String)EclipseProjectFinder.findProjectName(pathToProjectFile))) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    static String expandEclipseRelative2ContentRoots(@NotNull List<String> currentRoots, @NotNull String rootPath, @Nullable String relativeToRootPath) {
        if (currentRoots == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/eclipse/conversion/EPathUtil.expandEclipseRelative2ContentRoots must not be null");
        }
        if (rootPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/eclipse/conversion/EPathUtil.expandEclipseRelative2ContentRoots must not be null");
        }
        for (String currentRoot : currentRoots) {
            if (!currentRoot.endsWith(rootPath) && !Comparing.strEqual((String)rootPath, (String)EclipseProjectFinder.findProjectName(currentRoot))) continue;
            if (relativeToRootPath == null) {
                return VfsUtil.pathToUrl((String)currentRoot);
            }
            File relativeToOtherModuleFile = new File(currentRoot, relativeToRootPath);
            if (!relativeToOtherModuleFile.exists()) continue;
            return VfsUtil.pathToUrl((String)relativeToOtherModuleFile.getPath());
        }
        return null;
    }

    @Nullable
    static String expandEclipseRelative2OtherModule(@NotNull Module otherModule, @Nullable String relativeToOtherModule) {
        VirtualFile[] contentRoots;
        if (otherModule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/eclipse/conversion/EPathUtil.expandEclipseRelative2OtherModule must not be null");
        }
        for (VirtualFile contentRoot : contentRoots = ModuleRootManager.getInstance((Module)otherModule).getContentRoots()) {
            if (relativeToOtherModule == null) {
                return contentRoot.getUrl();
            }
            VirtualFile fileUnderModuleContentRoot = contentRoot.findFileByRelativePath(relativeToOtherModule);
            if (fileUnderModuleContentRoot == null) continue;
            return fileUnderModuleContentRoot.getUrl();
        }
        return null;
    }

    static String expandEclipsePath2Url(String path, ModifiableRootModel model, List<String> currentRoots) {
        VirtualFile jarFile;
        VirtualFile localFile;
        VirtualFile contentRoot = EPathUtil.getContentRoot((ModuleRootModel)model);
        LOG.assertTrue(contentRoot != null);
        String rootPath = contentRoot.getPath();
        String url = null;
        if (new File(path).exists()) {
            url = VfsUtil.pathToUrl((String)path);
        } else {
            String relativePath = new File(rootPath, path).getPath();
            File file = new File(relativePath);
            if (file.exists()) {
                url = VfsUtil.pathToUrl((String)relativePath);
            } else if (path.startsWith("/")) {
                String moduleName = EPathUtil.getRelativeModuleName(path);
                String relativeToRootPath = EPathUtil.getRelativeToModulePath(path);
                Module otherModule = ModuleManager.getInstance((Project)model.getModule().getProject()).findModuleByName(moduleName);
                if (otherModule != null && otherModule != model.getModule()) {
                    url = EPathUtil.expandEclipseRelative2OtherModule(otherModule, relativeToRootPath);
                } else if (currentRoots != null) {
                    url = EPathUtil.expandEclipseRelative2ContentRoots(currentRoots, moduleName, relativeToRootPath);
                }
            }
        }
        if (url == null) {
            url = VfsUtil.pathToUrl((String)path);
        }
        if ((localFile = VirtualFileManager.getInstance().findFileByUrl(url)) != null && (jarFile = JarFileSystem.getInstance().getJarRootForLocalFile(localFile)) != null) {
            url = jarFile.getUrl();
        }
        return url;
    }

    @Nullable
    public static String collapse2eclipseRelative2OtherModule(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/eclipse/conversion/EPathUtil.collapse2eclipseRelative2OtherModule must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/eclipse/conversion/EPathUtil.collapse2eclipseRelative2OtherModule must not be null");
        }
        Module module = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)project);
        if (module != null) {
            return EPathUtil.collapse2eclipsePathRelative2Module(file, module);
        }
        if (ProjectRootManager.getInstance((Project)project).getFileIndex().isIgnored(file)) {
            for (Module aModule : ModuleManager.getInstance((Project)project).getModules()) {
                String path = EPathUtil.collapse2eclipsePathRelative2Module(file, aModule);
                if (path == null) continue;
                return path;
            }
        }
        return null;
    }

    @Nullable
    private static String collapse2eclipsePathRelative2Module(VirtualFile file, Module module) {
        VirtualFile[] contentRoots;
        for (VirtualFile otherRoot : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (!VfsUtil.isAncestor((VirtualFile)otherRoot, (VirtualFile)file, (boolean)false)) continue;
            return "/" + module.getName() + "/" + VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)otherRoot, (char)'/');
        }
        return null;
    }

    @Nullable
    public static VirtualFile getContentRoot(ModuleRootModel model) {
        VirtualFile[] contentRoots;
        for (VirtualFile virtualFile : contentRoots = model.getContentRoots()) {
            if (virtualFile.findChild(".project") == null) continue;
            return virtualFile;
        }
        return null;
    }

    static String collapse2EclipsePath(String url, ModuleRootModel model) {
        VirtualFile projectBaseDir;
        String rootUrl;
        Project project = model.getModule().getProject();
        VirtualFile contentRoot = EPathUtil.getContentRoot(model);
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file != null) {
            if (file.getFileSystem() instanceof JarFileSystem) {
                file = JarFileSystem.getInstance().getVirtualFileForJar(file);
            }
            LOG.assertTrue(file != null);
            if (contentRoot != null && VfsUtil.isAncestor((VirtualFile)contentRoot, (VirtualFile)file, (boolean)false)) {
                return VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)contentRoot, (char)'/');
            }
            String path = EPathUtil.collapse2eclipseRelative2OtherModule(project, file);
            if (path != null) {
                return path;
            }
            return ProjectRootManagerImpl.extractLocalPath((String)url);
        }
        if (contentRoot != null && url.startsWith(rootUrl = contentRoot.getUrl()) && url.length() > rootUrl.length()) {
            return url.substring(rootUrl.length() + 1);
        }
        VirtualFile virtualFile = projectBaseDir = contentRoot != null ? contentRoot.getParent() : project.getBaseDir();
        assert (projectBaseDir != null);
        String projectUrl = projectBaseDir.getUrl();
        if (url.startsWith(projectUrl)) {
            return url.substring(projectUrl.length());
        }
        return ProjectRootManagerImpl.extractLocalPath((String)url);
    }

    @Nullable
    static String collapse2EclipseVariabledPath(LibraryOrderEntry libraryOrderEntry, OrderRootType type) {
        VirtualFile[] virtualFiles = libraryOrderEntry.getRootFiles(type);
        if (virtualFiles.length > 0) {
            VirtualFile jarFile = virtualFiles[0];
            if (jarFile.getFileSystem() instanceof JarFileSystem) {
                jarFile = JarFileSystem.getInstance().getVirtualFileForJar(jarFile);
            }
            if (jarFile == null) {
                return null;
            }
            Project project = libraryOrderEntry.getOwnerModule().getProject();
            VirtualFile baseDir = project.getBaseDir();
            String filePath = jarFile.getPath();
            if (baseDir != null && !VfsUtil.isAncestor((VirtualFile)baseDir, (VirtualFile)jarFile, (boolean)false)) {
                String ideaCollapsed = PathMacroManager.getInstance((ComponentManager)project).collapsePath(filePath);
                if (ideaCollapsed.contains("..")) {
                    return null;
                }
                int index = ideaCollapsed.indexOf(36);
                if (index < 0) {
                    return null;
                }
                return ideaCollapsed.substring(index).replace("$", "");
            }
        }
        for (String url : libraryOrderEntry.getRootUrls(type)) {
            String filePath = VirtualFileManager.extractPath((String)url);
            int jarSeparatorIdx = filePath.indexOf("!/");
            if (jarSeparatorIdx > -1) {
                filePath = filePath.substring(0, jarSeparatorIdx);
            }
            PathMacros pathMacros = PathMacros.getInstance();
            Set names = pathMacros.getUserMacroNames();
            for (String name : names) {
                String path = FileUtil.toSystemIndependentName((String)pathMacros.getValue(name));
                if (!filePath.startsWith(path + "/")) continue;
                String substr = filePath.substring(path.length());
                return name + (substr.startsWith("/") || substr.length() == 0 ? substr : "/" + substr);
            }
        }
        return null;
    }
}

