/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.util.text.StringUtil;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.eclipse.config.CachedXmlDocumentSet;

@State(name="EclipseModuleManager", storages={@Storage(id="default", file="$MODULE_FILE$")})
public class EclipseModuleManager
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String VALUE_ATTR = "value";
    @NonNls
    private static final String VARELEMENT = "varelement";
    @NonNls
    private static final String VAR_ATTRIBUTE = "var";
    @NonNls
    private static final String CONELEMENT = "conelement";
    @NonNls
    private static final String FORCED_JDK = "forced_jdk";
    private CachedXmlDocumentSet myDocumentSet;
    private final Map<String, String> myEclipseVariablePaths = new LinkedHashMap<String, String>();
    private final Set<String> myEclipseUrls = new LinkedHashSet<String>();
    private final Set<String> myUnknownCons = new LinkedHashSet<String>();
    private boolean myForceConfigureJDK = false;
    @NonNls
    private static final String SRC_PREFIX = "src:";
    @NonNls
    private static final String SRC_LINK_PREFIX = "linksrc:";
    @NonNls
    private static final String PREFIX_ATTR = "kind";
    private final Module myModule;
    @NonNls
    private static final String LIBELEMENT = "libelement";

    public EclipseModuleManager(Module module) {
        this.myModule = module;
    }

    public static EclipseModuleManager getInstance(Module module) {
        return (EclipseModuleManager)ModuleServiceManager.getService((Module)module, EclipseModuleManager.class);
    }

    public CachedXmlDocumentSet getDocumentSet() {
        return this.myDocumentSet;
    }

    public void setDocumentSet(CachedXmlDocumentSet documentSet) {
        this.myDocumentSet = documentSet;
    }

    public void registerEclipseVariablePath(String path, String var) {
        this.myEclipseVariablePaths.put(path, var);
    }

    public void registerEclipseSrcVariablePath(String path, String var) {
        this.myEclipseVariablePaths.put(SRC_PREFIX + path, var);
    }

    public void registerEclipseLinkedSrcVarPath(String path, String var) {
        this.myEclipseVariablePaths.put(SRC_LINK_PREFIX + path, var);
    }

    public String getEclipseLinkedSrcVariablePath(String path) {
        return this.myEclipseVariablePaths.get(SRC_LINK_PREFIX + path);
    }

    public String getEclipseVariablePath(String path) {
        return this.myEclipseVariablePaths.get(path);
    }

    public String getEclipseSrcVariablePath(String path) {
        return this.myEclipseVariablePaths.get(SRC_PREFIX + path);
    }

    public void registerUnknownCons(String con) {
        this.myUnknownCons.add(con);
    }

    public Set<String> getUnknownCons() {
        return this.myUnknownCons;
    }

    public boolean isForceConfigureJDK() {
        return this.myForceConfigureJDK;
    }

    public void setForceConfigureJDK() {
        this.myForceConfigureJDK = true;
    }

    public void registerEclipseLibUrl(String url) {
        this.myEclipseUrls.add(url);
    }

    public boolean isEclipseLibUrl(String url) {
        return this.myEclipseUrls.contains(url);
    }

    public Element getState() {
        if (!(ClasspathStorage.getStorageType((Module)this.myModule).equals("eclipse") || this.myEclipseUrls.isEmpty() && this.myEclipseVariablePaths.isEmpty() && !this.myForceConfigureJDK && this.myUnknownCons.isEmpty())) {
            Element root = new Element("EclipseModuleSettings");
            for (String eclipseUrl : this.myEclipseUrls) {
                Element libElement = new Element(LIBELEMENT);
                libElement.setAttribute(VALUE_ATTR, eclipseUrl);
                root.addContent(libElement);
            }
            for (String var : this.myEclipseVariablePaths.keySet()) {
                Element varElement = new Element(VARELEMENT);
                if (var.startsWith(SRC_PREFIX)) {
                    varElement.setAttribute(VAR_ATTRIBUTE, StringUtil.trimStart((String)var, (String)SRC_PREFIX));
                    varElement.setAttribute(PREFIX_ATTR, SRC_PREFIX);
                } else if (var.startsWith(SRC_LINK_PREFIX)) {
                    varElement.setAttribute(VAR_ATTRIBUTE, StringUtil.trimStart((String)var, (String)SRC_LINK_PREFIX));
                    varElement.setAttribute(PREFIX_ATTR, SRC_LINK_PREFIX);
                } else {
                    varElement.setAttribute(VAR_ATTRIBUTE, var);
                }
                varElement.setAttribute(VALUE_ATTR, this.myEclipseVariablePaths.get(var));
                root.addContent(varElement);
            }
            for (String unknownCon : this.myUnknownCons) {
                Element conElement = new Element(CONELEMENT);
                conElement.setAttribute(VALUE_ATTR, unknownCon);
                root.addContent(conElement);
            }
            if (this.myForceConfigureJDK) {
                root.setAttribute(FORCED_JDK, String.valueOf(true));
            }
            return root;
        }
        return null;
    }

    public void loadState(Element state) {
        for (Object o : state.getChildren(LIBELEMENT)) {
            this.myEclipseUrls.add(((Element)o).getAttributeValue(VALUE_ATTR));
        }
        for (Object o : state.getChildren(VARELEMENT)) {
            String prefix = ((Element)o).getAttributeValue(PREFIX_ATTR);
            this.myEclipseVariablePaths.put(((Element)o).getAttributeValue(VAR_ATTRIBUTE), (prefix != null ? prefix : "") + ((Element)o).getAttributeValue(VALUE_ATTR));
        }
        for (Object o : state.getChildren(CONELEMENT)) {
            this.myUnknownCons.add(((Element)o).getAttributeValue(VALUE_ATTR));
        }
        String forcedJdk = state.getAttributeValue(FORCED_JDK);
        this.myForceConfigureJDK = forcedJdk != null && Boolean.parseBoolean(forcedJdk);
    }
}

