#!/bin/sh
echo 'name: convertible
version: 1.0.10.0
id: convertible-1.0.10.0-efff1b5b9ced288c234a7de56789d623

license: LGPL
copyright: Copyright (c) 2009-2010 John Goerzen
maintainer: John Goerzen <jgoerzen@complete.org>
stability: Stable
homepage: http://hackage.haskell.org/cgi-bin/hackage-scripts/package/convertible
package-url:
description: convertible provides a typeclass with a single function
             that is designed to help convert between different types: numeric
             values, dates and times, and the like.  The conversions perform bounds
             checking and return a pure Either value.  This means that you need
             not remember which specific function performs the conversion you
             desire.
             .
             Also included in the package are optional instances that provide
             conversion for various numeric and time types, as well as utilities
             for writing your own instances.
             .
             Finally, there is a function that will raise an exception on
             bounds-checking violation, or return a bare value otherwise,
             implemented in terms of the safer function described above.
             .
             Convertible is also used by HDBC 2.0 for handling marshalling of
             data to and from databases.
             .
             Convertible is backed by an extensive test suite and passes tests
             on GHC and Hugs.
category: Data
author: John Goerzen
pkgpath: devel/hs-convertible
exposed: True
exposed-modules: Data.Convertible Data.Convertible.Base
                 Data.Convertible.Utils Data.Convertible.Instances
                 Data.Convertible.Instances.C Data.Convertible.Instances.Map
                 Data.Convertible.Instances.Num Data.Convertible.Instances.Text
                 Data.Convertible.Instances.Time
hidden-modules:
import-dirs: /usr/local/lib/ghc/convertible-1.0.10.0
library-dirs: /usr/local/lib/ghc/convertible-1.0.10.0
hs-libraries: HSconvertible-1.0.10.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-912d55d387093f740e3bcd2ffbf1dd83
         bytestring-0.9.1.10-e7cebdd905566e960c42140389871ec1
         containers-0.4.0.0-18deac99a132f04751d862b77aab136e
         mtl-2.0.1.0-9763a8821c812a910d327bad2c0d23b2
         old-locale-1.0.0.2-6e2a3c0744e8cf4e0ac2d4e58659f7b5
         old-time-1.0.0.6-37d6575186c36059fbc372c289dbddd4
         text-0.11.0.6-ace87dcbd28176f4bf784c8b8e080ab9
         time-1.2.0.3-57ebba2cc05370f666b7eceba5e468a9
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-convertible-1.0.10.0/html/convertible.haddock
haddock-html: /usr/local/share/doc/hs-convertible-1.0.10.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
