/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;

public abstract class AbstractWriter {
    protected static final char NEWLINE = '\n';
    private Writer writer;
    private ElementIterator iter;
    private Document document;
    private int maxLineLength;
    private int lineLength;
    private boolean canWrapLines;
    private int indentSpace;
    private int indentLevel;
    private boolean indented;
    private int startOffset;
    private int endOffset;
    private String lineSeparator;
    private char[] lineSeparatorChars;

    private /* synthetic */ void finit$() {
        this.maxLineLength = 100;
        this.indentSpace = 2;
        this.lineSeparator = "\n";
        this.lineSeparatorChars = this.lineSeparator.toCharArray();
    }

    protected AbstractWriter(Writer writer, Document document) {
        this.finit$();
        this.writer = writer;
        this.iter = new ElementIterator(document);
        this.document = document;
        this.startOffset = 0;
        this.endOffset = document.getLength();
    }

    protected AbstractWriter(Writer writer, Document document, int n, int n2) {
        this.finit$();
        this.writer = writer;
        this.iter = new ElementIterator(document);
        this.document = document;
        this.startOffset = n;
        this.endOffset = n + n2;
    }

    protected AbstractWriter(Writer writer, Element element) {
        this.finit$();
        this.writer = writer;
        this.iter = new ElementIterator(element);
        this.document = element.getDocument();
        this.startOffset = element.getStartOffset();
        this.endOffset = element.getEndOffset();
    }

    protected AbstractWriter(Writer writer, Element element, int n, int n2) {
        this.finit$();
        this.writer = writer;
        this.iter = new ElementIterator(element);
        this.document = element.getDocument();
        this.startOffset = n;
        this.endOffset = n + n2;
    }

    protected ElementIterator getElementIterator() {
        return this.iter;
    }

    protected Writer getWriter() {
        return this.writer;
    }

    protected Document getDocument() {
        return this.document;
    }

    protected abstract void write() throws IOException, BadLocationException;

    protected String getText(Element element) throws BadLocationException {
        if (!element.isLeaf()) {
            throw new BadLocationException("Element is not a leaf", element.getStartOffset());
        }
        return this.document.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
    }

    protected void output(char[] cArray, int n, int n2) throws IOException {
        this.writer.write(cArray, n, n2);
        this.lineLength += n2;
    }

    protected void writeLineSeparator() throws IOException {
        this.output(this.lineSeparatorChars, 0, this.lineSeparatorChars.length);
        this.lineLength = 0;
        this.indented = false;
    }

    protected void write(char c) throws IOException {
        this.write(new char[]{c}, 0, 1);
    }

    protected void write(String string) throws IOException {
        char[] cArray = string.toCharArray();
        this.write(cArray, 0, cArray.length);
    }

    protected void write(char[] cArray, int n, int n2) throws IOException {
        if (this.getCanWrapLines()) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3;
                while (n3 < n2 && cArray[n + n3] != ' ') {
                    ++n3;
                }
                if (n3 < n2 && this.lineLength + n3 - n4 >= this.maxLineLength) {
                    this.writeLineSeparator();
                } else if (n3 < n2) {
                    ++n3;
                }
                this.output(cArray, n + n4, n + n3 - n4);
            }
        } else {
            int n5 = n;
            for (int i = n; i < n + n2; ++i) {
                if (cArray[i] != '\n') continue;
                this.output(cArray, n5, i - n5);
                this.writeLineSeparator();
            }
            if (n5 < n + n2 - 1) {
                this.output(cArray, n5, n + n2 - n5);
            }
        }
    }

    protected void indent() throws IOException {
        int n = this.indentLevel * this.indentSpace;
        if (n > 0) {
            char[] cArray = new char[n];
            Arrays.fill(cArray, ' ');
            this.write(cArray, 0, cArray.length);
        }
        this.indented = true;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    protected boolean inRange(Element element) {
        int n = element.getStartOffset();
        int n2 = element.getEndOffset();
        return n >= this.startOffset && n < this.endOffset || n2 >= this.startOffset && n2 < this.endOffset;
    }

    protected void text(Element element) throws BadLocationException, IOException {
        int n = element.getStartOffset();
        int n2 = element.getEndOffset();
        n = Math.max(n, this.startOffset);
        n2 = Math.min(n2, this.endOffset);
        this.write(this.document.getText(n, n2));
    }

    protected void setLineLength(int n) {
        this.maxLineLength = n;
    }

    protected int getLineLength() {
        return this.maxLineLength;
    }

    protected void setCurrentLineLength(int n) {
        this.lineLength = n;
    }

    protected int getCurrentLineLength() {
        return this.lineLength;
    }

    protected boolean isLineEmpty() {
        return this.lineLength == 0 && !this.indented;
    }

    protected void setCanWrapLines(boolean bl) {
        this.canWrapLines = bl;
    }

    protected boolean getCanWrapLines() {
        return this.canWrapLines;
    }

    protected void setIndentSpace(int n) {
        this.indentSpace = n;
    }

    protected int getIndentSpace() {
        return this.indentSpace;
    }

    public void setLineSeparator(String string) {
        this.lineSeparator = string;
        this.lineSeparatorChars = string.toCharArray();
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    protected void incrIndent() {
        ++this.indentLevel;
    }

    protected void decrIndent() {
        --this.indentLevel;
    }

    protected int getIndentLevel() {
        return this.indentLevel;
    }

    protected void writeAttributes(AttributeSet attributeSet) throws IOException {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            Object object2 = attributeSet.getAttribute(object);
            this.write(object + "=" + object2);
            this.writeLineSeparator();
        }
    }
}

