/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import java.io.IOException;
import java.io.Reader;

class BufferedReader
extends Reader {
    static final int DEFAULT_BUFFER_SIZE = 4096;
    final Reader in;
    char[] buf;
    int pos;
    int count;
    int markpos;
    int marklimit;
    int bufferSize;

    BufferedReader(Reader reader) {
        this(reader, 4096);
    }

    BufferedReader(Reader reader, int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.in = reader;
        this.bufferSize = n;
        this.buf = new char[n];
        this.pos = this.count = n;
    }

    public void close() throws IOException {
        this.buf = null;
        this.count = 0;
        this.pos = 0;
        this.markpos = -1;
        this.in.close();
    }

    public void mark(int n) throws IOException {
        this.marklimit = n;
        this.markpos = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        if (this.pos >= this.count && !this.refill()) {
            return -1;
        }
        return this.buf[this.pos++];
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || cArray.length - n < n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.pos >= this.count && !this.refill()) {
            return -1;
        }
        int n3 = Math.min(this.count - this.pos, n2);
        System.arraycopy(this.buf, this.pos, cArray, n, n3);
        this.pos += n3;
        n += n3;
        n2 -= n3;
        while (n2 > 0 && this.refill()) {
            int n4 = Math.min(this.count - this.pos, n2);
            System.arraycopy(this.buf, this.pos, cArray, n, n4);
            this.pos += n4;
            n += n4;
            n2 -= n4;
            n3 += n4;
        }
        return n3;
    }

    public void reset() throws IOException {
        if (this.markpos == -1) {
            throw new IOException(this.buf == null ? "Stream closed." : "Invalid mark.");
        }
        this.pos = this.markpos;
    }

    public long skip(long l) throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed.");
        }
        long l2 = l;
        while (l > 0L && (this.pos < this.count || this.refill())) {
            int n = (int)Math.min((long)(this.count - this.pos), l);
            this.pos += n;
            l -= (long)n;
        }
        return l2 - l;
    }

    private boolean refill() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed.");
        }
        int n = this.count - this.markpos;
        if (this.markpos == -1 || n >= this.marklimit) {
            this.markpos = -1;
            this.count = 0;
            this.pos = 0;
        } else {
            char[] cArray = this.buf;
            if (this.markpos < this.bufferSize) {
                cArray = new char[this.count - this.markpos + this.bufferSize];
            }
            System.arraycopy(this.buf, this.markpos, cArray, 0, n);
            this.buf = cArray;
            this.count = n;
            this.pos -= this.markpos;
            this.markpos = 0;
        }
        int n2 = this.in.read(this.buf, this.count, this.bufferSize);
        if (n2 <= 0) {
            return false;
        }
        this.count += n2;
        return true;
    }
}

