/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.libxmlj.sax;

import gnu.xml.libxmlj.sax.GnomeXMLReader;
import gnu.xml.libxmlj.sax.XMLName;
import org.xml.sax.Attributes;

class StringArrayAttributes
implements Attributes {
    private int len;
    private XMLName[] keys;
    private String[] values;

    StringArrayAttributes(GnomeXMLReader gnomeXMLReader, String[] stringArray) {
        this.len = stringArray == null ? 0 : stringArray.length / 2;
        this.keys = new XMLName[this.len];
        this.values = new String[this.len];
        for (int i = 0; i < this.len; ++i) {
            int n = i * 2;
            this.keys[i] = new XMLName(gnomeXMLReader, stringArray[n]);
            this.values[i] = stringArray[n + 1];
        }
    }

    public int getLength() {
        return this.len;
    }

    public String getURI(int n) {
        if (n < 0 || n >= this.len) {
            return null;
        }
        return this.keys[n].uri;
    }

    public String getLocalName(int n) {
        if (n < 0 || n >= this.len) {
            return null;
        }
        return this.keys[n].localName;
    }

    public String getQName(int n) {
        if (n < 0 || n >= this.len) {
            return null;
        }
        return this.keys[n].qName;
    }

    public String getType(int n) {
        if (n < 0 || n >= this.len) {
            return null;
        }
        return "CDATA";
    }

    public String getValue(int n) {
        if (n < 0 || n >= this.len) {
            return null;
        }
        return this.values[n];
    }

    public int getIndex(String string, String string2) {
        for (int i = 0; i < this.len; ++i) {
            XMLName xMLName = this.keys[i];
            if (!xMLName.localName.equals(string2) || (xMLName.uri != null || string != null) && (xMLName.uri == null || !xMLName.uri.equals(string))) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(String string) {
        for (int i = 0; i < this.len; ++i) {
            if (!this.keys[i].qName.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String getType(String string, String string2) {
        return this.getType(this.getIndex(string, string2));
    }

    public String getType(String string) {
        return this.getType(this.getIndex(string));
    }

    public String getValue(String string, String string2) {
        return this.getValue(this.getIndex(string, string2));
    }

    public String getValue(String string) {
        return this.getValue(this.getIndex(string));
    }
}

