/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.assembly;

import gnu.javax.crypto.assembly.Direction;
import gnu.javax.crypto.assembly.LoopbackTransformer;
import gnu.javax.crypto.assembly.Operation;
import gnu.javax.crypto.assembly.Transformer;
import gnu.javax.crypto.assembly.TransformerException;
import java.util.Map;

public class Assembly {
    public static final String DIRECTION = "gnu.crypto.assembly.assembly.direction";
    private Direction wired = null;
    private Transformer head = new LoopbackTransformer();

    public void addPreTransformer(Transformer transformer2) {
        this.wireTransformer(transformer2, Operation.PRE_PROCESSING);
    }

    public void addPostTransformer(Transformer transformer2) {
        this.wireTransformer(transformer2, Operation.POST_PROCESSING);
    }

    public void init(Map map) throws TransformerException {
        if (this.wired != null) {
            throw new IllegalStateException();
        }
        Direction direction = (Direction)map.get(DIRECTION);
        if (direction == null) {
            direction = Direction.FORWARD;
        }
        map.put("gnu.crypto.assembly.transformer.direction", direction);
        this.head.init(map);
        this.wired = direction;
    }

    public void reset() {
        this.head.reset();
        this.wired = null;
    }

    public byte[] update(byte by) throws TransformerException {
        return this.update(new byte[]{by}, 0, 1);
    }

    public byte[] update(byte[] byArray) throws TransformerException {
        return this.update(byArray, 0, byArray.length);
    }

    public byte[] update(byte[] byArray, int n, int n2) throws TransformerException {
        if (this.wired == null) {
            throw new IllegalStateException();
        }
        return this.head.update(byArray, n, n2);
    }

    public byte[] lastUpdate() throws TransformerException {
        return this.lastUpdate(new byte[0], 0, 0);
    }

    public byte[] lastUpdate(byte by) throws TransformerException {
        return this.lastUpdate(new byte[]{by}, 0, 1);
    }

    public byte[] lastUpdate(byte[] byArray) throws TransformerException {
        return this.lastUpdate(byArray, 0, byArray.length);
    }

    public byte[] lastUpdate(byte[] byArray, int n, int n2) throws TransformerException {
        if (this.wired == null) {
            throw new IllegalStateException();
        }
        byte[] byArray2 = this.head.lastUpdate(byArray, n, n2);
        this.reset();
        return byArray2;
    }

    private void wireTransformer(Transformer transformer2, Operation operation) {
        if (transformer2.tail != null) {
            throw new IllegalArgumentException();
        }
        transformer2.setMode(operation);
        transformer2.tail = this.head;
        this.head = transformer2;
    }
}

