/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.rsa;

import gnu.java.security.Registry;
import gnu.java.security.action.GetPropertyAction;
import gnu.java.security.key.rsa.GnuRSAKey;
import gnu.java.security.key.rsa.RSAKeyPairRawCodec;
import gnu.java.security.key.rsa.RSAKeyPairX509Codec;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;

public class GnuRSAPublicKey
extends GnuRSAKey
implements PublicKey,
RSAPublicKey {
    private transient String str;

    public GnuRSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this(1, bigInteger, bigInteger2);
    }

    public GnuRSAPublicKey(int n, BigInteger bigInteger, BigInteger bigInteger2) {
        super(n == 4 ? 2 : n, bigInteger, bigInteger2);
    }

    public static GnuRSAPublicKey valueOf(byte[] byArray) {
        if (byArray[0] == Registry.MAGIC_RAW_RSA_PUBLIC_KEY[0]) {
            try {
                return (GnuRSAPublicKey)new RSAKeyPairRawCodec().decodePublicKey(byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return (GnuRSAPublicKey)new RSAKeyPairX509Codec().decodePublicKey(byArray);
    }

    public byte[] getEncoded(int n) {
        byte[] byArray;
        switch (n) {
            case 1: {
                byArray = new RSAKeyPairRawCodec().encodePublicKey(this);
                break;
            }
            case 2: {
                byArray = new RSAKeyPairX509Codec().encodePublicKey(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported encoding format: " + n);
            }
        }
        return byArray;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RSAPublicKey)) {
            return false;
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)object;
        return super.equals(rSAPublicKey) && this.getPublicExponent().equals(rSAPublicKey.getPublicExponent());
    }

    public String toString() {
        if (this.str == null) {
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            this.str = new StringBuilder(this.getClass().getName()).append("(").append(super.toString()).append(",").append(string).append(")").toString();
        }
        return this.str;
    }
}

