/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.encoder;

import gnu.java.beans.encoder.Context;
import gnu.java.beans.encoder.ObjectId;
import gnu.java.beans.encoder.Root;
import gnu.java.beans.encoder.ScannerState;
import gnu.java.beans.encoder.elements.ArrayInstantiation;
import gnu.java.beans.encoder.elements.Array_Get;
import gnu.java.beans.encoder.elements.Array_Set;
import gnu.java.beans.encoder.elements.ClassResolution;
import gnu.java.beans.encoder.elements.List_Get;
import gnu.java.beans.encoder.elements.List_Set;
import gnu.java.beans.encoder.elements.MethodInvocation;
import gnu.java.beans.encoder.elements.NullObject;
import gnu.java.beans.encoder.elements.ObjectInstantiation;
import gnu.java.beans.encoder.elements.ObjectReference;
import gnu.java.beans.encoder.elements.PrimitiveInstantiation;
import gnu.java.beans.encoder.elements.StaticFieldAccess;
import gnu.java.beans.encoder.elements.StaticMethodInvocation;
import gnu.java.beans.encoder.elements.StringReference;
import java.util.HashMap;

class GenericScannerState
extends ScannerState {
    private int skipElements;
    private int initialSkipElements;
    final Root root;
    HashMap skipValues;

    GenericScannerState(Root root) {
        this.root = root;
    }

    GenericScannerState(Root root, int n) {
        this(root);
        this.skipElements = this.initialSkipElements = n;
        if (n > 0) {
            this.skipValues = new HashMap();
        }
    }

    protected void enterImpl(Context context) {
        if (this.skipValues != null) {
            Integer n = (Integer)this.skipValues.get(context);
            if (n == null) {
                n = this.initialSkipElements;
                this.skipValues.put(context, n);
            }
            this.skipElements = n;
        }
    }

    void methodInvocation(String string) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new MethodInvocation(string));
    }

    void staticMethodInvocation(String string, String string2) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new StaticMethodInvocation(string, string2));
    }

    void staticFieldAccess(String string, String string2) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new StaticFieldAccess(string, string2));
    }

    void classResolution(String string) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new ClassResolution(string));
    }

    void objectInstantiation(String string, ObjectId objectId) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        ObjectInstantiation objectInstantiation = new ObjectInstantiation(string);
        objectInstantiation.initId(objectId);
        this.root.addChild(objectInstantiation);
    }

    void primitiveInstantiation(String string, String string2) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new PrimitiveInstantiation(string, string2));
    }

    void objectArrayInstantiation(String string, String string2, ObjectId objectId) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        ArrayInstantiation arrayInstantiation = new ArrayInstantiation(string, string2);
        arrayInstantiation.initId(objectId);
        this.root.addChild(arrayInstantiation);
    }

    void primitiveArrayInstantiation(String string, String string2, ObjectId objectId) {
        this.objectArrayInstantiation(string, string2, objectId);
    }

    void arraySet(String string) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new Array_Set(string));
    }

    void arrayGet(String string) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new Array_Get(string));
    }

    void listGet() {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new List_Get());
    }

    void listSet() {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new List_Set());
    }

    void nullObject() {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new NullObject());
    }

    void stringReference(String string) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new StringReference(string));
    }

    void objectReference(ObjectId objectId) {
        if (this.skipValues != null && this.skipElements > 0) {
            return;
        }
        this.root.addChild(new ObjectReference(objectId));
    }

    void end() {
        if (this.skipValues != null) {
            if (this.skipElements > 0) {
                --this.skipElements;
            } else {
                this.root.end();
            }
            this.skipValues.put(this.context(), this.skipElements);
        } else {
            this.root.end();
        }
    }

    void enter() {
    }
}

