/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.logicalstructures;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ILogicalStructureTypeDelegate;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.internal.debug.core.logicalstructures.LogicalObjectStructureInterfaceType;

public abstract class LogicalObjectStructureClassType
extends LogicalObjectStructureInterfaceType
implements ILogicalStructureTypeDelegate {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean providesLogicalStructure(IValue value) {
        if (!(value instanceof IJavaObject)) return false;
        IJavaObject object = (IJavaObject)value;
        try {
            IJavaType type = object.getJavaType();
            if (!(type instanceof IJavaClassType)) return false;
            IJavaClassType classType = (IJavaClassType)type;
            String targetClass = this.getTargetClassName();
            while (true) {
                if (classType == null) {
                    return false;
                }
                if (classType.getName().equals(targetClass)) {
                    return true;
                }
                classType = classType.getSuperclass();
            }
        }
        catch (DebugException debugException) {}
        return false;
    }

    protected abstract String getTargetClassName();

    protected String getTargetInterfaceName() {
        return null;
    }
}

