/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.internal.core.history.LocalFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.internal.ui.history.TypedBufferedContent;
import org.eclipse.team.ui.ISaveableWorkbenchPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;

public class CompareFileRevisionEditorInput
extends CompareEditorInput
implements ISaveableWorkbenchPart {
    static final int NO_CURRENT = -1;
    static final int LEFT = 0;
    static final int RIGHT = 1;
    private ITypedElement left;
    private ITypedElement right;
    private IFile resource;
    private int currentSide;

    public CompareFileRevisionEditorInput(FileRevisionTypedElement left, FileRevisionTypedElement right) {
        super(new CompareConfiguration());
        this.left = left;
        this.right = right;
        this.resource = null;
        this.currentSide = -1;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.initLabels();
        if (this.resource != null) {
            switch (this.currentSide) {
                case 0: {
                    this.left = new TypedBufferedContent(this.resource);
                    this.getCompareConfiguration().setLeftEditable(true);
                    break;
                }
                case 1: {
                    CompareConfiguration cc = this.getCompareConfiguration();
                    String leftLabel = cc.getLeftLabel((Object)this.left);
                    String rightLabel = cc.getRightLabel((Object)this.right);
                    ITypedElement tempElement = this.left;
                    this.left = new TypedBufferedContent(this.resource);
                    this.right = tempElement;
                    cc.setLeftEditable(true);
                    cc.setLeftLabel(rightLabel);
                    cc.setRightLabel(leftLabel);
                }
            }
        }
        return new DiffNode(this.left, this.right);
    }

    private void initLabels() {
        CompareConfiguration cc = this.getCompareConfiguration();
        cc.setLeftEditable(false);
        cc.setRightEditable(false);
        String leftLabel = this.getFileRevisionLabel((FileRevisionTypedElement)this.left);
        cc.setLeftLabel(leftLabel);
        String rightLabel = this.getFileRevisionLabel((FileRevisionTypedElement)this.right);
        cc.setRightLabel(rightLabel);
    }

    private String getFileRevisionLabel(FileRevisionTypedElement element) {
        String label = null;
        Object fileObject = element.getFileRevision();
        if (fileObject instanceof LocalFileRevision) {
            try {
                IStorage storage = ((LocalFileRevision)fileObject).getStorage((IProgressMonitor)new NullProgressMonitor());
                if (Utils.getAdapter(storage, IFileState.class) != null) {
                    label = NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_localRevision, (Object[])new Object[]{element.getName(), element.getTimestamp()});
                } else if (Utils.getAdapter(storage, IFile.class) != null) {
                    label = NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_workspace, (Object[])new Object[]{element.getName(), element.getTimestamp()});
                    this.resource = (IFile)storage;
                    this.currentSide = element == this.left ? 0 : 1;
                }
            }
            catch (CoreException coreException) {}
        } else {
            label = NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_repository, (Object[])new Object[]{element.getName(), element.getContentIdentifier()});
        }
        return label;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.saveChanges(monitor);
        }
        catch (CoreException e) {
            Utils.handle(e);
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void addPropertyListener(IPropertyListener listener) {
    }

    public void createPartControl(Composite parent) {
        this.createContents(parent);
    }

    public void dispose() {
    }

    public IWorkbenchPartSite getSite() {
        return null;
    }

    public String getToolTipText() {
        Object[] titleObject = new Object[]{this.getLongName(this.left), this.getContentIdentifier(this.left), this.getContentIdentifier(this.right)};
        return NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_compareResourceAndVersions, (Object[])titleObject);
    }

    public void removePropertyListener(IPropertyListener listener) {
    }

    public String getTitle() {
        Object[] titleObject = new Object[]{this.getShortName(this.left), this.getContentIdentifier(this.left), this.getContentIdentifier(this.right)};
        return NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_compareResourceAndVersions, (Object[])titleObject);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IFile.class || adapter == IResource.class) {
            return this.resource;
        }
        return super.getAdapter(adapter);
    }

    private String getShortName(ITypedElement element) {
        if (element instanceof FileRevisionTypedElement) {
            FileRevisionTypedElement fileRevisionElement = (FileRevisionTypedElement)element;
            return fileRevisionElement.getName();
        }
        if (element instanceof TypedBufferedContent) {
            TypedBufferedContent typedContent = (TypedBufferedContent)element;
            return typedContent.getResource().getName();
        }
        return "";
    }

    private String getLongName(ITypedElement element) {
        if (element instanceof FileRevisionTypedElement) {
            FileRevisionTypedElement fileRevisionElement = (FileRevisionTypedElement)element;
            return fileRevisionElement.getPath();
        }
        if (element instanceof TypedBufferedContent) {
            TypedBufferedContent typedContent = (TypedBufferedContent)element;
            return typedContent.getResource().getFullPath().toString();
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getContentIdentifier(ITypedElement element) {
        if (element instanceof FileRevisionTypedElement) {
            FileRevisionTypedElement fileRevisionElement = (FileRevisionTypedElement)element;
            Object fileObject = fileRevisionElement.getFileRevision();
            if (!(fileObject instanceof LocalFileRevision)) return fileRevisionElement.getContentIdentifier();
            try {
                IStorage storage = ((LocalFileRevision)fileObject).getStorage((IProgressMonitor)new NullProgressMonitor());
                if (Utils.getAdapter(storage, IFileState.class) != null) {
                    return TeamUIMessages.CompareFileRevisionEditorInput_0;
                }
                if (Utils.getAdapter(storage, IFile.class) == null) return "";
                return TeamUIMessages.CompareFileRevisionEditorInput_1;
            }
            catch (CoreException coreException) {}
            return "";
        }
        if (!(element instanceof TypedBufferedContent)) return "";
        return TeamUIMessages.CompareFileRevisionEditorInput_2;
    }

    public String getTitleToolTip() {
        return this.getTitleToolTip();
    }
}

