/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.actions;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;
import org.eclipse.team.internal.core.history.LocalFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.history.AbstractHistoryCategory;
import org.eclipse.team.internal.ui.history.CompareFileRevisionEditorInput;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class CompareRevisionAction
extends BaseSelectionListenerAction {
    HistoryPage page;
    IStructuredSelection selection;
    IFileRevision currentFileRevision;

    public CompareRevisionAction(String text) {
        super(text);
    }

    public void run() {
        try {
            IStructuredSelection structSel = this.selection;
            Object[] objArray = structSel.toArray();
            IFileRevision file1 = null;
            IFileRevision file2 = null;
            switch (structSel.size()) {
                case 1: {
                    file1 = this.getCurrentFileRevision();
                    Object tempRevision = objArray[0];
                    if (tempRevision instanceof IFileRevision) {
                        file2 = (IFileRevision)tempRevision;
                        break;
                    }
                    return;
                }
                case 2: {
                    Object tempRevision2 = objArray[0];
                    Object tempRevision3 = objArray[1];
                    if (tempRevision2 instanceof IFileRevision && tempRevision3 instanceof IFileRevision) {
                        file1 = (IFileRevision)objArray[0];
                        file2 = (IFileRevision)objArray[1];
                        break;
                    }
                    return;
                }
            }
            if (file1 == null || file2 == null || !file1.exists() || !file2.exists()) {
                MessageDialog.openError((Shell)this.page.getSite().getShell(), (String)TeamUIMessages.OpenRevisionAction_DeletedRevTitle, (String)TeamUIMessages.CompareRevisionAction_DeleteCompareMessage);
                return;
            }
            FileRevisionTypedElement left = new FileRevisionTypedElement(file1);
            FileRevisionTypedElement right = new FileRevisionTypedElement(file2);
            CompareFileRevisionEditorInput input = new CompareFileRevisionEditorInput(left, right);
            IWorkbenchPage workBenchPage = this.page.getSite().getPage();
            IEditorPart editor = CompareRevisionAction.findReusableCompareEditor(workBenchPage);
            if (editor != null) {
                IEditorInput otherInput = editor.getEditorInput();
                if (otherInput.equals(input)) {
                    workBenchPage.activate((IWorkbenchPart)editor);
                } else {
                    CompareUI.reuseCompareEditor((CompareEditorInput)input, (IReusableEditor)((IReusableEditor)editor));
                    workBenchPage.activate((IWorkbenchPart)editor);
                }
            } else {
                CompareUI.openCompareEditor((CompareEditorInput)input);
            }
        }
        catch (Exception exception) {}
    }

    private IFileRevision getCurrentFileRevision() {
        return this.currentFileRevision;
    }

    public void setCurrentFileRevision(IFileRevision fileRevision) {
        this.currentFileRevision = fileRevision;
    }

    public static IEditorPart findReusableCompareEditor(IWorkbenchPage page) {
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part != null && part.getEditorInput() instanceof CompareFileRevisionEditorInput && part instanceof IReusableEditor && !part.isDirty()) {
                return part;
            }
            ++i;
        }
        return null;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.selection = selection;
        if (selection.size() == 1) {
            Object el = selection.getFirstElement();
            if (el instanceof LocalFileRevision) {
                this.setText(TeamUIMessages.CompareRevisionAction_Local);
            } else if (el instanceof FileRevision) {
                FileRevision tempFileRevision = (FileRevision)el;
                this.setText(NLS.bind((String)TeamUIMessages.CompareRevisionAction_Revision, (Object[])new String[]{tempFileRevision.getContentIdentifier()}));
            } else {
                this.setText(TeamUIMessages.CompareRevisionAction_CompareWithCurrent);
            }
            return this.shouldShow();
        }
        if (selection.size() == 2) {
            this.setText(TeamUIMessages.CompareRevisionAction_CompareWithOther);
            return this.shouldShow();
        }
        return false;
    }

    public void setPage(HistoryPage page) {
        this.page = page;
    }

    private boolean shouldShow() {
        IStructuredSelection structSel = this.selection;
        Object[] objArray = structSel.toArray();
        if (objArray.length == 0) {
            return false;
        }
        int i = 0;
        while (i < objArray.length) {
            if (objArray[i] instanceof AbstractHistoryCategory) {
                return false;
            }
            IFileRevision revision = (IFileRevision)objArray[i];
            if (revision != null && !revision.exists()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

