/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.JarFactoryContainer;
import org.eclipse.jdt.apt.core.internal.util.FactoryContainer;

public class WkspJarFactoryContainer
extends JarFactoryContainer {
    private final String _id;
    private final File _jarFile;

    public WkspJarFactoryContainer(IPath jar) {
        this._id = jar.toString();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = root.findMember(this._id);
        if (res == null) {
            this._jarFile = root.getLocation().append(jar).toFile();
        } else if (res.getType() == 1) {
            this._jarFile = res.getLocation().toFile();
        } else {
            this._jarFile = null;
            Status s = AptPlugin.createWarningStatus(null, "The factorypath entry " + this._id + " does not refer to a jar file");
            AptPlugin.log((IStatus)s);
        }
    }

    public FactoryContainer.FactoryType getType() {
        return FactoryContainer.FactoryType.WKSPJAR;
    }

    public File getJarFile() {
        return this._jarFile;
    }

    public String getId() {
        return this._id;
    }
}

