/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.importexport.breakpoints;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.debug.internal.ui.importexport.breakpoints.EmbeddedBreakpointsViewer;
import org.eclipse.debug.internal.ui.importexport.breakpoints.ImportExportMessages;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewer;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.ExportBreakpointsOperation;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class WizardExportBreakpointsPage
extends WizardPage
implements Listener {
    private Button fOverwriteExistingFilesCheckbox = null;
    private Text fDestinationNameField = null;
    private Button fDestinationBrowseButton = null;
    private IPath fPath = null;
    private EmbeddedBreakpointsViewer fTView = null;
    private IStructuredSelection fSelection = null;
    private Button fSelectAll = null;
    private Button fDeselectAll = null;
    private static final String OVERWRITE_ALL_STATE = "overwrite";
    private static final String DESTINATION_FILE_NAME = "filename";

    public WizardExportBreakpointsPage(String pageName, IStructuredSelection selection) {
        super(pageName, ImportExportMessages.WizardExportBreakpoints_0, null);
        this.fSelection = selection;
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.fDestinationBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        } else if (source == this.fDestinationNameField) {
            this.handlePathTextModifiedEvent();
        } else if (source == this.fSelectAll) {
            this.handleSelectAllPressed();
        } else if (source == this.fDeselectAll) {
            this.handleDeselectAllPressed();
        }
    }

    private void handleSelectAllPressed() {
        BreakpointsViewer viewer = this.fTView.getViewer();
        viewer.getTree().selectAll();
        viewer.setCheckedElements(((IStructuredSelection)viewer.getSelection()).toArray());
        viewer.setGrayedElements(new Object[0]);
        viewer.getTree().deselectAll();
        this.setPageComplete(this.detectPageComplete());
    }

    private void handleDeselectAllPressed() {
        BreakpointsViewer viewer = this.fTView.getViewer();
        viewer.setCheckedElements(new Object[0]);
        viewer.setGrayedElements(new Object[0]);
        this.setPageComplete(this.detectPageComplete());
    }

    protected void handlePathTextModifiedEvent() {
        this.setPageComplete(this.detectPageComplete());
    }

    protected void handleDestinationBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.bkpt"});
        dialog.setText(ImportExportMessages.WizardExportBreakpoints_0);
        String file = dialog.open();
        if (file != null) {
            this.fPath = new Path(file);
            if (this.fPath != null) {
                this.setErrorMessage(null);
                if (this.fPath.getFileExtension() == null) {
                    this.fPath = this.fPath.addFileExtension("bkpt");
                } else if (!this.fPath.getFileExtension().equals("bkpt")) {
                    this.fPath = this.fPath.addFileExtension("bkpt");
                }
                this.fDestinationNameField.setText(this.fPath.toString());
            }
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.fTView = new EmbeddedBreakpointsViewer(composite, DebugPlugin.getDefault().getBreakpointManager(), this.fSelection);
        this.fTView.getViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                WizardExportBreakpointsPage.this.setPageComplete(WizardExportBreakpointsPage.this.detectPageComplete());
            }
        });
        this.fTView.getViewer().setSelection((ISelection)this.fSelection);
        this.createButtonsGroup(composite);
        this.createDestinationGroup(composite);
        this.createOptionsGroup(composite);
        this.setControl((Control)composite);
        this.setPageComplete(this.detectPageComplete());
        this.restoreWidgetState();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IDebugHelpContextIds.EXPORT_BREAKPOINTS_WIZARD_PAGE);
        Dialog.applyDialogFont((Control)parent);
    }

    public Image getImage() {
        return DebugUITools.getImage("IMG_WIZBAN_EXPORT_BREAKPOINTS");
    }

    private void createButtonsGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        this.fSelectAll = SWTUtil.createPushButton(composite, ImportExportMessages.WizardBreakpointsPage_1, null);
        this.fSelectAll.addListener(13, (Listener)this);
        this.fDeselectAll = SWTUtil.createPushButton(composite, ImportExportMessages.WizardBreakpointsPage_2, null);
        this.fDeselectAll.addListener(13, (Listener)this);
    }

    private boolean detectPageComplete() {
        boolean emptyFile = this.fDestinationNameField.getText().trim().equals("");
        if (emptyFile) {
            this.setMessage(ImportExportMessages.WizardExportBreakpointsPage_0, 0);
            return false;
        }
        int size = this.fTView.getCheckedElements().size();
        if (size == 0) {
            this.setMessage(ImportExportMessages.WizardExportBreakpointsPage_1, 3);
            return false;
        }
        this.setMessage(ImportExportMessages.WizardBreakpointsPage_4);
        return true;
    }

    protected void createOptionsGroup(Composite parent) {
        Font font = parent.getFont();
        Group OptionsGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        OptionsGroup.setLayout((Layout)layout);
        OptionsGroup.setLayoutData((Object)new GridData(768));
        OptionsGroup.setText(ImportExportMessages.WizardBreakpointsPage_5);
        OptionsGroup.setFont(parent.getFont());
        this.fOverwriteExistingFilesCheckbox = new Button((Composite)OptionsGroup, 16416);
        this.fOverwriteExistingFilesCheckbox.setText(ImportExportMessages.WizardBreakpointsPage_6);
        this.fOverwriteExistingFilesCheckbox.setFont(font);
    }

    protected void createDestinationGroup(Composite parent) {
        Font font = parent.getFont();
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        destinationSelectionGroup.setFont(font);
        Label destinationLabel = new Label(destinationSelectionGroup, 0);
        destinationLabel.setText(ImportExportMessages.WizardBreakpointsPage_7);
        destinationLabel.setFont(font);
        this.fDestinationNameField = new Text(destinationSelectionGroup, 2048);
        this.fDestinationNameField.addListener(24, (Listener)this);
        GridData data = new GridData(768);
        this.fDestinationNameField.setLayoutData((Object)data);
        this.fDestinationNameField.setFont(font);
        this.fDestinationBrowseButton = new Button(destinationSelectionGroup, 8);
        this.fDestinationBrowseButton.setText(ImportExportMessages.WizardBreakpointsPage_8);
        this.fDestinationBrowseButton.addListener(13, (Listener)this);
        this.fDestinationBrowseButton.setFont(font);
        this.setButtonLayoutData(this.fDestinationBrowseButton);
    }

    private void saveWidgetState() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(OVERWRITE_ALL_STATE, this.fOverwriteExistingFilesCheckbox.getSelection());
            settings.put(DESTINATION_FILE_NAME, this.fDestinationNameField.getText().trim());
        }
    }

    private void restoreWidgetState() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fOverwriteExistingFilesCheckbox.setSelection(Boolean.valueOf(settings.get(OVERWRITE_ALL_STATE)).booleanValue());
            String filename = settings.get(DESTINATION_FILE_NAME);
            if (filename != null) {
                this.fDestinationNameField.setText(filename);
            }
        }
    }

    public boolean finish() {
        block10: {
            if (this.fPath == null) {
                this.fPath = new Path(this.fDestinationNameField.getText().trim());
                if (this.fPath.getFileExtension() == null) {
                    this.fPath = this.fPath.addFileExtension("bkpt");
                } else if (!this.fPath.getFileExtension().equals("bkpt")) {
                    this.fPath = this.fPath.addFileExtension("bkpt");
                }
            }
            this.saveWidgetState();
            if (!this.fPath.toFile().exists() || this.fOverwriteExistingFilesCheckbox.getSelection() || MessageDialog.openQuestion(null, (String)ImportExportMessages.WizardBreakpointsPage_12, (String)MessageFormat.format((String)ImportExportMessages.ImportExportOperations_0, (Object[])new String[]{this.fPath.toPortableString()}))) break block10;
            return false;
        }
        try {
            Object[] elements = this.fTView.getCheckedElements().toArray();
            ArrayList<Object> breakpoints = new ArrayList<Object>();
            int i = 0;
            while (i < elements.length) {
                Object object = elements[i];
                if (object instanceof IBreakpoint) {
                    breakpoints.add(object);
                }
                ++i;
            }
            this.getContainer().run(true, true, (IRunnableWithProgress)new ExportBreakpointsOperation(breakpoints.toArray(new IBreakpoint[breakpoints.size()]), this.fPath.toOSString()));
        }
        catch (InterruptedException e) {
            DebugPlugin.log((Throwable)e);
            return false;
        }
        catch (InvocationTargetException e) {
            DebugPlugin.log((Throwable)e);
            return false;
        }
        return true;
    }
}

