/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.template.java.JavaContextType;
import org.eclipse.jdt.internal.corext.template.java.JavaDocContextType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.TemplateContextType;

public final class TemplateCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private final TemplateEngine fJavaTemplateEngine;
    private final TemplateEngine fJavadocTemplateEngine;
    private static final Set KEYWORDS;

    static {
        HashSet<String> keywords = new HashSet<String>(42);
        keywords.add("abstract");
        keywords.add("assert");
        keywords.add("break");
        keywords.add("case");
        keywords.add("catch");
        keywords.add("class");
        keywords.add("continue");
        keywords.add("default");
        keywords.add("do");
        keywords.add("else");
        keywords.add("elseif");
        keywords.add("extends");
        keywords.add("final");
        keywords.add("finally");
        keywords.add("for");
        keywords.add("if");
        keywords.add("implements");
        keywords.add("import");
        keywords.add("instanceof");
        keywords.add("interface");
        keywords.add("native");
        keywords.add("new");
        keywords.add("package");
        keywords.add("private");
        keywords.add("protected");
        keywords.add("public");
        keywords.add("return");
        keywords.add("static");
        keywords.add("strictfp");
        keywords.add("super");
        keywords.add("switch");
        keywords.add("synchronized");
        keywords.add("this");
        keywords.add("throw");
        keywords.add("throws");
        keywords.add("transient");
        keywords.add("try");
        keywords.add("volatile");
        keywords.add("while");
        keywords.add("true");
        keywords.add("false");
        keywords.add("null");
        KEYWORDS = Collections.unmodifiableSet(keywords);
    }

    public TemplateCompletionProposalComputer() {
        TemplateContextType contextType = JavaPlugin.getDefault().getTemplateContextRegistry().getContextType("java");
        if (contextType == null) {
            contextType = new JavaContextType();
            JavaPlugin.getDefault().getTemplateContextRegistry().addContextType(contextType);
        }
        this.fJavaTemplateEngine = contextType != null ? new TemplateEngine(contextType) : null;
        contextType = JavaPlugin.getDefault().getTemplateContextRegistry().getContextType("javadoc");
        if (contextType == null) {
            contextType = new JavaDocContextType();
            JavaPlugin.getDefault().getTemplateContextRegistry().addContextType(contextType);
        }
        this.fJavadocTemplateEngine = contextType != null ? new TemplateEngine(contextType) : null;
    }

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        TemplateEngine engine;
        try {
            String partition = TextUtilities.getContentType((IDocument)context.getDocument(), (String)"___java_partitioning", (int)context.getInvocationOffset(), (boolean)true);
            engine = partition.equals("__java_javadoc") ? this.fJavadocTemplateEngine : this.fJavaTemplateEngine;
        }
        catch (BadLocationException badLocationException) {
            return Collections.EMPTY_LIST;
        }
        if (engine != null) {
            if (!(context instanceof JavaContentAssistInvocationContext)) {
                return Collections.EMPTY_LIST;
            }
            JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
            ICompilationUnit unit = javaContext.getCompilationUnit();
            if (unit == null) {
                return Collections.EMPTY_LIST;
            }
            engine.reset();
            engine.complete(javaContext.getViewer(), javaContext.getInvocationOffset(), unit);
            TemplateProposal[] templateProposals = engine.getResults();
            ArrayList result = new ArrayList(Arrays.asList(templateProposals));
            IJavaCompletionProposal[] keyWordResults = javaContext.getKeywordProposals();
            if (keyWordResults.length > 0) {
                ArrayList<TemplateProposal> removals = new ArrayList<TemplateProposal>();
                if (keyWordResults.length > 0) {
                    int k = 0;
                    while (k < templateProposals.length) {
                        block11: {
                            TemplateProposal curr = templateProposals[k];
                            String name = curr.getTemplate().getName();
                            int i = 0;
                            while (i < keyWordResults.length) {
                                String keyword = keyWordResults[i].getDisplayString();
                                if (name.startsWith(keyword)) {
                                    curr.setRelevance(keyWordResults[i].getRelevance() + 1);
                                    break block11;
                                }
                                ++i;
                            }
                            if (this.isKeyword(name)) {
                                removals.add(curr);
                            }
                        }
                        ++k;
                    }
                }
                result.removeAll(removals);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.EMPTY_LIST;
    }

    private boolean isKeyword(String name) {
        return KEYWORDS.contains(name);
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionStarted() {
    }

    public void sessionEnded() {
        this.fJavadocTemplateEngine.reset();
        this.fJavaTemplateEngine.reset();
    }
}

