/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.formatter.BlankLinesTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.BracesTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.CommentsTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.ControlStatementsTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.IndentationTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.LineWrappingTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.NewLinesTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.RenameProfileDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.WhiteSpaceTabPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ModifyDialog
extends StatusDialog {
    private static final String DS_KEY_PREFERRED_WIDTH = "org.eclipse.jdt.uiformatter_page.modify_dialog.preferred_width";
    private static final String DS_KEY_PREFERRED_HEIGHT = "org.eclipse.jdt.uiformatter_page.modify_dialog.preferred_height";
    private static final String DS_KEY_PREFERRED_X = "org.eclipse.jdt.uiformatter_page.modify_dialog.preferred_x";
    private static final String DS_KEY_PREFERRED_Y = "org.eclipse.jdt.uiformatter_page.modify_dialog.preferred_y";
    private static final String DS_KEY_LAST_FOCUS = "org.eclipse.jdt.uiformatter_page.modify_dialog.last_focus";
    private final String fTitle;
    private final boolean fNewProfile;
    private ProfileManager.Profile fProfile;
    private final Map fWorkingValues;
    private IStatus fStandardStatus;
    protected final List fTabPages;
    final IDialogSettings fDialogSettings;
    private TabFolder fTabFolder;
    private ProfileManager fProfileManager;
    private Button fApplyButton;

    protected ModifyDialog(Shell parentShell, ProfileManager.Profile profile, ProfileManager profileManager, boolean newProfile) {
        super(parentShell);
        this.fProfileManager = profileManager;
        this.fNewProfile = newProfile;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.fProfile = profile;
        if (this.fProfile.isBuiltInProfile()) {
            this.fStandardStatus = new Status(1, JavaPlugin.getPluginId(), 0, FormatterMessages.ModifyDialog_dialog_show_warning_builtin, null);
            this.fTitle = Messages.format(FormatterMessages.ModifyDialog_dialog_show_title, profile.getName());
        } else {
            this.fStandardStatus = new Status(0, JavaPlugin.getPluginId(), 0, "", null);
            this.fTitle = Messages.format(FormatterMessages.ModifyDialog_dialog_title, profile.getName());
        }
        this.fWorkingValues = new HashMap(this.fProfile.getSettings());
        this.updateStatus(this.fStandardStatus);
        this.setStatusLineAboveButtons(false);
        this.fTabPages = new ArrayList();
        this.fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
    }

    public void create() {
        super.create();
        int lastFocusNr = 0;
        try {
            lastFocusNr = this.fDialogSettings.getInt(DS_KEY_LAST_FOCUS);
            if (lastFocusNr < 0) {
                lastFocusNr = 0;
            }
            if (lastFocusNr > this.fTabPages.size() - 1) {
                lastFocusNr = this.fTabPages.size() - 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            lastFocusNr = 0;
        }
        if (!this.fNewProfile) {
            this.fTabFolder.setSelection(lastFocusNr);
            ((ModifyDialogTabPage)this.fTabFolder.getSelection()[0].getData()).setInitialFocus();
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.fTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.fTabFolder = new TabFolder(composite, 0);
        this.fTabFolder.setFont(composite.getFont());
        this.fTabFolder.setLayoutData((Object)new GridData(1808));
        this.addTabPage(this.fTabFolder, FormatterMessages.ModifyDialog_tabpage_indentation_title, new IndentationTabPage(this, this.fWorkingValues));
        this.addTabPage(this.fTabFolder, FormatterMessages.ModifyDialog_tabpage_braces_title, new BracesTabPage(this, this.fWorkingValues));
        this.addTabPage(this.fTabFolder, FormatterMessages.ModifyDialog_tabpage_whitespace_title, new WhiteSpaceTabPage(this, this.fWorkingValues));
        this.addTabPage(this.fTabFolder, FormatterMessages.ModifyDialog_tabpage_blank_lines_title, new BlankLinesTabPage(this, this.fWorkingValues));
        this.addTabPage(this.fTabFolder, FormatterMessages.ModifyDialog_tabpage_new_lines_title, new NewLinesTabPage(this, this.fWorkingValues));
        this.addTabPage(this.fTabFolder, FormatterMessages.ModifyDialog_tabpage_control_statements_title, new ControlStatementsTabPage(this, this.fWorkingValues));
        this.addTabPage(this.fTabFolder, FormatterMessages.ModifyDialog_tabpage_line_wrapping_title, new LineWrappingTabPage(this, this.fWorkingValues));
        this.addTabPage(this.fTabFolder, FormatterMessages.ModifyDialog_tabpage_comments_title, new CommentsTabPage(this, this.fWorkingValues));
        ModifyDialog.applyDialogFont((Control)composite);
        this.fTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TabItem tabItem = (TabItem)e.item;
                ModifyDialogTabPage page = (ModifyDialogTabPage)tabItem.getData();
                ModifyDialog.this.fDialogSettings.put(ModifyDialog.DS_KEY_LAST_FOCUS, ModifyDialog.this.fTabPages.indexOf(page));
                page.makeVisible();
            }
        });
        return composite;
    }

    public void updateStatus(IStatus status) {
        super.updateStatus(status != null ? status : this.fStandardStatus);
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        try {
            int lastHeight;
            int lastWidth = this.fDialogSettings.getInt(DS_KEY_PREFERRED_WIDTH);
            if (initialSize.x > lastWidth) {
                lastWidth = initialSize.x;
            }
            if (initialSize.y > (lastHeight = this.fDialogSettings.getInt(DS_KEY_PREFERRED_HEIGHT))) {
                lastHeight = initialSize.x;
            }
            return new Point(lastWidth, lastHeight);
        }
        catch (NumberFormatException numberFormatException) {
            return initialSize;
        }
    }

    protected Point getInitialLocation(Point initialSize) {
        try {
            return new Point(this.fDialogSettings.getInt(DS_KEY_PREFERRED_X), this.fDialogSettings.getInt(DS_KEY_PREFERRED_Y));
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialLocation(initialSize);
        }
    }

    public boolean close() {
        Rectangle shell = this.getShell().getBounds();
        this.fDialogSettings.put(DS_KEY_PREFERRED_WIDTH, shell.width);
        this.fDialogSettings.put(DS_KEY_PREFERRED_HEIGHT, shell.height);
        this.fDialogSettings.put(DS_KEY_PREFERRED_X, shell.x);
        this.fDialogSettings.put(DS_KEY_PREFERRED_Y, shell.y);
        return super.close();
    }

    protected void okPressed() {
        this.applyPressed();
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1024) {
            this.applyPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void applyPressed() {
        if (this.fProfile.isBuiltInProfile() || this.fProfile.isSharedProfile()) {
            RenameProfileDialog dialog = new RenameProfileDialog(this.getShell(), this.fProfile, this.fProfileManager);
            if (dialog.open() != 0) {
                return;
            }
            this.fProfile = dialog.getRenamedProfile();
            this.fStandardStatus = new Status(0, JavaPlugin.getPluginId(), 0, "", null);
            this.updateStatus(this.fStandardStatus);
        }
        this.fProfile.setSettings(new HashMap(this.fWorkingValues));
        this.fApplyButton.setEnabled(false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fApplyButton = this.createButton(parent, 1024, FormatterMessages.ModifyDialog_apply_button, false);
        this.fApplyButton.setEnabled(false);
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        Label label = new Label(parent, 0);
        GridData data = new GridData();
        data.widthHint = layout.horizontalSpacing;
        label.setLayoutData((Object)data);
        super.createButtonsForButtonBar(parent);
    }

    private final void addTabPage(TabFolder tabFolder, String title, ModifyDialogTabPage tabPage) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        ModifyDialog.applyDialogFont((Control)tabItem.getControl());
        tabItem.setText(title);
        tabItem.setData((Object)tabPage);
        tabItem.setControl((Control)tabPage.createContents((Composite)tabFolder));
        this.fTabPages.add(tabPage);
    }

    public void valuesModified() {
        if (this.fApplyButton != null && !this.fApplyButton.isDisposed()) {
            this.fApplyButton.setEnabled(this.hasChanges());
        }
    }

    private boolean hasChanges() {
        for (Map.Entry curr : this.fProfile.getSettings().entrySet()) {
            if (this.fWorkingValues.get(curr.getKey()).equals(curr.getValue())) continue;
            return true;
        }
        return false;
    }
}

